<?php /**/ /*cleaned*/?><?php
/**
* Upgrade controller for Forms Component
*
* @version		$Id: controller.php 179 2009-08-18 01:33:14Z dr_drsh $
* @package		Joomla
* @subpackage	JForms
* @copyright	Copyright (C) 2008 Mostafa Muhammad. All rights reserved.
* @license		GNU/GPL
*/

jimport('joomla.application.component.controller');

/**
 * Main backend Controller
 *
 * @package    Joomla
 * @subpackage JForms
 */
 
 
class UpgradeController extends JController{

	/**
	 * constructor (registers additional tasks to methods)
	 *
	 * @return void
	 */
	function __construct(){
		parent::__construct();
		// Register Extra tasks
		$this->registerTask( 'upgrade'  , 'upgrade');
	}


	function upgrade(){
		
		JRequest::checkToken('get') or jexit( 'Invalid Token' );

		$sourceVersion	= JRequest::getInt( 'src' , 'get' );
		$destVersion	= JRequest::getInt( 'dest', 'get' );
		
		if(JFile::exists(JFORMS_BACKEND_PATH.DS.'installation'.DS.'upgrade'.DS.'upgrade_'.$sourceVersion.'_'.$destVersion.'.php')){
			include_once JFORMS_BACKEND_PATH.DS.'installation'.DS.'upgrade'.DS.'upgrade_'.$sourceVersion.'_'.$destVersion.'.php';
		} else {
			jexit( 'Invalid version' );
		}

		$step			= JRequest::getInt( 'step' , 'get' );
		$param			= JRequest::getVar( 'param', 'get' );
		
		$return = JFormsUpgrade::process( $step, $param );
		
		if( strpos( $return, JURI::base()) === false  ){
			jexit( $return );		
		} else { 
			$this->setRedirect( $return );
		}
	}

	function display()
	{
		$document =& JFactory::getDocument();

		$viewType	= $document->getType();
		$viewName	= 'upgrade';
		$viewLayout	= 'default';
		$view = & $this->getView( $viewName, $viewType, '', array( 'base_path'=>$this->_basePath));

		// Set the layout
		$view->setLayout($viewLayout);
		
		// Display the view
		$view->display();
	}
}
