/**
 * JavaScript file for Elements: Main stuff
 *
 * @package     NoNumber! Elements
 * @version     1.5.3
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

window.addEvent( 'domready', function() {
	// correct td widths
	$$('.paramlist_key').each( function( td ) {
		td.setStyle( 'width', 140 );
	});
	$$('.paramlist_value').each( function( td ) {
		if ( td.getAttribute( 'colspan' ) == 2 ) {
			td.setStyle( 'width', 140 );
		}
	});

	if ( $('nn_param_preloader') ) {
		$('nn_param_preloader').setStyles({
			visibility: 'hidden'
		});
		( function() {
			$('nn_param_preloader_container').innerHTML = '';
			$('nn_param_preloader').setStyles({
				visibility: 'visible'
			}).injectInside( $('nn_param_preloader_container') );
		} ).delay(2000);
	}
});

function NoNumberElementsHideTD( id )
{
	var div = document.getElementById(id);
	div.parentNode.style.padding=0;
	div.parentNode.style.height=0;
	div.parentNode.style.border=0;

	div.parentNode.parentNode.style.display='none';
}

function NoNumberElementsChangeView( val ) {
	document.getElementById('paramsview_state'+val).click();
	$( document.getElementById('view_state_div') ).removeClass('view_state_0').removeClass('view_state_1').removeClass('view_state_2').addClass('view_state_'+val);
}