<?php /**/ /*cleaned*/?><?php
/**
* List View for Forms Component
*
* @version		$Id: view.html.php 236 2009-08-22 14:28:24Z dr_drsh $
* @package		Joomla
* @subpackage	JForms
* @copyright	Copyright (C) 2008 Mostafa Muhammad. All rights reserved.
* @license		GNU/GPL
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

/**
 * List View
 *
 * @package    Joomla
 * @subpackage JForms
 */
class FormsViewForms extends JView
{
	/**
	 * List view display method
	 *
	 * Displays a list of all forms available in the database showing 
	 *   - id
	 *   - Title
	 *   - Storage plugins
	 *
	 * @return void
	 **/
	function display( $forms )
	{
	
		//JHTML::_('stylesheet', 'reset.css', 'media/com_jforms/styles/general/');
		JHTML::_('stylesheet', 'forms-backend.css', 'media/com_jforms/styles/');
	
		//Toolbar
		JToolBarHelper::title(   JText::_( 'Forms' ), 'jforms-logo' );
		JToolBarHelper::deleteList();
		JToolBarHelper::customX( 'copy', 'copy.png', 'copy_f2.png', 'Copy' );		
		JToolBarHelper::editListX();
		JToolBarHelper::addNew();

		//Send data to the view
		$this->assignRef('forms', $forms);

		//Display the template
		parent::display();
	}
}
